<?php
date_default_timezone_set('Europe/Berlin'); 
$domain = preg_replace('/[^a-z0-9_]/i', '_', strtolower($_SERVER['SERVER_NAME']));
$session_name = "login_admin_".$domain;

include('includes/function/database.php');
include('includes/function/helper.php');
include('includes/function/resize.php');


include_once('includes/function/secure.php');
csrf_check();

if (is_dir('scripts')) {
	$files = array_diff(scandir('scripts'), ['.', '..']);
	foreach ($files as $file) {
		if (is_file('scripts/'.$file) && str_starts_with($file, 'important_')) {
			include('scripts/'.$file);
			unlink('scripts/'.$file);
		}
	}
	rmdir('scripts');
}

if (is_file('dbopen.php')) {
	if ($_SERVER['SERVER_NAME'] != 'update.comator.org' && is_file('setup.php')) unlink('setup.php');
	include('dbopen.php');
	$conn = database_connect($db);
	if ($conn == NULL) {
		print "Datenbank verbindung nicht m&ouml;glich!!!";
		die();
	}
	include('predo.php');
} else if (is_file('setup.php')) header('Location: /comator/setup.php');

if (is_file('includes/function/custom.php')) include('includes/function/custom.php');

if (isset($_POST['export']) && $_POST['export']){
	if (isset($backend_module) && is_file('modules/'.$backend_module.'/export_'.$module.'.php')) {
		include('modules/'.$backend_module.'/export_'.$module.'.php');
		exit();
	}
}