<?php
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') $seo_host = 'https://'.$_SERVER['SERVER_NAME'];
else $seo_host = 'http://'.$_SERVER['SERVER_NAME'];

if (!file_exists($_SERVER['DOCUMENT_ROOT'].'/robots.txt')){
	$robots_txt = <<<TXT
User-agent: *
Disallow: /box/
Disallow: /comator/
Disallow: /form/
Disallow: /html/
Disallow: /includes/
Disallow: /nav/
Disallow: /products/
Disallow: /template/

Sitemap: {$seo_host}/sitemap.xml
TXT;

	file_put_contents($_SERVER['DOCUMENT_ROOT'].'/robots.txt', $robots_txt);
}

$pages = array('events', 'news');

$languages = array();
$sql = "SELECT iso FROM languages WHERE c_active = '1' ";
$result = $conn->prepare($sql);
$result->execute();
if ($result->rowCount()){
	while ($arr = $result->fetch()){
		$languages[] = $arr['iso'];
	}
}

$c_languages = false;
$sql = "SELECT id FROM languages ";
$result = $conn->prepare($sql);
$result->execute();
$count_languages = $result->rowCount();
if ($count_languages > 1) $c_languages = true;

$default_guidv4 = NULL;
$sql = "SELECT value FROM settings_options WHERE title = 'default_guidv4' LIMIT 1";
$result = $conn->prepare($sql);
$result->execute();
while ($arr = $result->fetch()){
	$default_guidv4 = $arr['value'];
}

if (!empty($languages)) {
	
	$sitemap = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	$sitemap .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\">\n";
	
	$placeholders = implode(',', array_fill(0, count($languages), '?'));
	$sql = "SELECT guidv4, url, language FROM content_levels WHERE position LIKE '%sitemap%' AND language IN ($placeholders) AND c_active = '1' ORDER BY sortorder ASC";
	$result = $conn->prepare($sql);
	$result->execute($languages);
	if ($result->rowCount()){
		while($arr = $result->fetch()){
			$url = $seo_host."/".url_slug($arr['url'])."/";
			if ($c_languages) $url = $seo_host."/".$arr['language']."/".url_slug($arr['url'])."/";
			if ($default_guidv4 == $arr['guidv4']){
				$url = $seo_host."/";
				if ($c_languages) $url = $seo_host."/".$arr['language']."/";
				$sitemap .= "  <url>\n";
				$sitemap .= "    <loc>".htmlspecialchars($url)."</loc>\n";
				$sitemap .= "    <changefreq>weekly</changefreq>\n";
				$sitemap .= "    <priority>1.0</priority>\n";
			} else {
				$sitemap .= "  <url>\n";
				$sitemap .= "    <loc>".htmlspecialchars($url)."</loc>\n";
				$sitemap .= "    <changefreq>weekly</changefreq>\n";
				$sitemap .= "    <priority>0.5</priority>\n";
			}
			
			
			if (check_table('teaser')){
				$sql_teaser = "SELECT teaser.* FROM teaser AS teaser 
											LEFT JOIN teaser_levels_links AS levels_links ON levels_links.id_module = teaser.id 
											WHERE levels_links.guidv4 = :guidv4 AND teaser.language = :language AND teaser.c_active = '1' 
											GROUP BY teaser.id ORDER BY teaser.sortorder ASC LIMIT 1";
				
				$result_teaser = $conn->prepare($sql_teaser);
				$result_teaser->bindValue(':guidv4', $arr['guidv4'], PDO::PARAM_STR);
				$result_teaser->bindValue(':language', $arr['language'], PDO::PARAM_STR);
				$result_teaser->execute();
				if ($result_teaser->rowCount()){
					$arr_teaser = $result_teaser->fetch();
					
					
					if (check_table('images')){
						$sql_image = "SELECT images.file, 
													module_images.c_enlarge, 
													IF(module_images.title != '', module_images.title, images.title) AS title  
													FROM images AS images 
													LEFT JOIN teaser_images AS module_images ON module_images.id_media = images.id 
													WHERE module_images.id_module = :id_module 
													GROUP BY module_images.id_media ORDER BY module_images.sortorder ASC LIMIT 1";
						$result_image = $conn->prepare($sql_image);
						$result_image->bindValue(':id_module', $arr_teaser['id'], PDO::PARAM_INT);
						$result_image->execute();
						if ($result_image->rowCount()){
							$arr_image = $result_image->fetch();
							
							$img_url = "/images/teaser/";
							if ($arr_image['c_enlarge'] && is_file($_SERVER['DOCUMENT_ROOT'].$img_url."lightbox/".$arr_image['file'])) $img_url .= "lightbox/".$arr_image['file'];
							else $img_url .= "thumb1/".$arr_image['file'];
							
							if (is_file($_SERVER['DOCUMENT_ROOT'].$img_url)){
								
								$img_title = htmlspecialchars($arr_image['title'] ?? '', ENT_XML1);
		
								$sitemap .= "    <image:image>\n";
								$sitemap .= "      <image:loc>".$seo_host.$img_url."</image:loc>\n";
								if (!empty($img_title)) {
									$sitemap .= "      <image:title>".$img_title."</image:title>\n";
								}
								$sitemap .= "    </image:image>\n";
							}
						}
					}
				}
			}
			$sitemap .= "  </url>\n";
		}
	}
	
	foreach ($pages AS $content) {
		if (check_table($content)){
			if ($content == 'events'){
				$placeholders_tmp = [];
				$params = [];
				
				foreach ($languages as $index => $lang) {
			    $key = ":lang".$index;
			    $placeholders_tmp[] = $key;
			    $params[$key] = $lang;
				}
				$params[':start'] = time();
				
				$sql = "SELECT id, url, language FROM ".$content." WHERE language IN (".implode(',', $placeholders_tmp).") AND c_active = '1' AND start >= :start ORDER BY start ASC";
				$result = $conn->prepare($sql);
				$result->execute($params);
			} else {
				$sql = "SELECT id, url, language FROM ".$content." WHERE language IN ($placeholders) AND c_active = '1' ORDER BY datetime DESC";
				$result = $conn->prepare($sql);
				$result->execute($languages);
			}
			if ($result->rowCount()){
				while($arr = $result->fetch()){
					$url = $seo_host."/".$content."/".url_slug($arr['url']).".html";
					if ($c_languages) $url = $seo_host."/".$arr['language']."/".$content."/".url_slug($arr['url']).".html";
					$sitemap .= "  <url>\n";
					$sitemap .= "    <loc>".htmlspecialchars($url)."</loc>\n";
					$sitemap .= "    <changefreq>daily</changefreq>\n";
					$sitemap .= "    <priority>0.9</priority>\n";
					
					
					if (check_table('images')){
						$sql_image = "SELECT images.file, 
													module_images.c_enlarge, 
													IF(module_images.title != '', module_images.title, images.title) AS title  
													FROM images AS images 
													LEFT JOIN ".$content."_images AS module_images ON module_images.id_media = images.id 
													WHERE module_images.id_module = :id_module 
													GROUP BY module_images.id_media ORDER BY module_images.sortorder ASC LIMIT 1";
						$result_image = $conn->prepare($sql_image);
						$result_image->bindValue(':id_module', $arr['id'], PDO::PARAM_INT);
						$result_image->execute();
						if ($result_image->rowCount()){
							$arr_image = $result_image->fetch();
							
							$img_url = "/images/".$content."/";
							if ($arr_image['c_enlarge'] && is_file($_SERVER['DOCUMENT_ROOT'].$img_url."lightbox/".$arr_image['file'])) $img_url .= "lightbox/".$arr_image['file'];
							else $img_url .= "thumb1/".$arr_image['file'];
							
							if (is_file($_SERVER['DOCUMENT_ROOT'].$img_url)){
								
								$img_title = htmlspecialchars($arr_image['title'] ?? '', ENT_XML1);
		
								$sitemap .= "    <image:image>\n";
								$sitemap .= "      <image:loc>".$seo_host.$img_url."</image:loc>\n";
								if (!empty($img_title)) {
									$sitemap .= "      <image:title>".$img_title."</image:title>\n";
								}
								$sitemap .= "    </image:image>\n";
							}
						}
					}
					
					
					$sitemap .= "  </url>\n";
				}
				
			}
		}
	}
	
	
	/*if (check_table('products_content')){
		$sql = "SELECT url, language FROM products_content WHERE language IN ($placeholders) AND c_active = '1'";
    $result = $conn->prepare($sql);
		$result->execute($languages);
		if ($result->rowCount()){
			while ($arr = $result->fetch()){
				$url = $seo_host."/".$arr['language']."/products/".url_slug($arr['url']).".html";
				$sitemap .= "  <url>\n";
				$sitemap .= "    <loc>".htmlspecialchars($url)."</loc>\n";
				$sitemap .= "    <changefreq>daily</changefreq>\n";
				$sitemap .= "    <priority>0.9</priority>\n";
				$sitemap .= "  </url>\n";
			}
		}
	}*/
	
	$sitemap .= "</urlset>\n";
	
	file_put_contents($_SERVER['DOCUMENT_ROOT'].'/sitemap.xml', $sitemap);
	
}