<?php
$db_data['structure']['content'] = "
CREATE TABLE `content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `c_thumbnails` enum('0','1') NOT NULL DEFAULT '0',
  `id_template` int(11) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `teaser` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addition` text DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `linktext` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_files'] = "
CREATE TABLE `content_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_module` int(11) DEFAULT NULL,
  `id_media` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `id_module` (`id_module`,`id_media`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_images'] = "
CREATE TABLE `content_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_module` int(11) DEFAULT NULL,
  `id_media` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `text` text DEFAULT NULL,
  `source` text DEFAULT NULL,
  `copyright` text DEFAULT NULL,
  `r_position_outside` varchar(2) DEFAULT NULL,
  `r_position_inside` varchar(2) DEFAULT NULL,
  `c_enlarge` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`), UNIQUE KEY `id_module` (`id_module`,`id_media`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_labels'] = "
CREATE TABLE `content_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
   PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_levels'] = "
CREATE TABLE `content_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `c_thumbnails` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `teaser` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addition` text DEFAULT NULL,
  `position` text DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `linktext` text DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  `parent_guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `guidv4` (`guidv4`,`language`), KEY `parent_guidv4` (`parent_guidv4`), KEY `guidv4_2` (`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_levels_links'] = "
CREATE TABLE `content_levels_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_module` int(11) DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `id_module` (`id_module`,`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_levels_position'] = "
CREATE TABLE `content_levels_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_modules'] = "
CREATE TABLE `content_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_options'] = "
CREATE TABLE `content_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_public` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['content_templates'] = "
CREATE TABLE `content_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['data']['backend_modules'] = "
INSERT IGNORE INTO`backend_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(1, 1, '1', 'content', 'Inhalte', 'de', '', '', '1', '1', '1', '1');";

$db_data['data']['content_labels'] = "
INSERT IGNORE INTO`content_labels` (`id`, `c_active`, `language`, `label`, `text`) VALUES
(1, '1', 'de', 'LABEL_TEMPLATE', 'Template'),
(2, '1', 'de', 'LABEL_TEMPLATES', 'Templates');";

$db_data['data']['content_levels_position'] = "
INSERT IGNORE INTO`content_levels_position` (`id`, `sortorder`, `c_active`, `title`) VALUES
(1, 1, '1', 'top'),
(2, 2, '1', 'bottom'),
(3, 3, '1', 'main'),
(4, 4, '1', 'mobile'),
(5, 5, '1', 'widget'),
(6, 6, '1', 'sitemap');";

$db_data['data']['content_modules'] = "
INSERT IGNORE INTO`content_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(1, 1, '1', 'content', 'Inhalte', 'de', '', '', '1', '1', '1', '1');";

$db_data['data']['content_options'] = "
INSERT IGNORE INTO`content_options` (`id`, `c_public`, `title`, `value`) VALUES
(1, '0', 'c_modules', '1'),
(2, '1', 'c_levels', '1'),
(3, '1', 'c_levels_multi', '0'),
(4, '1', 'c_templates', '1'),
(6, '1', 'c_images', '1'),
(7, '1', 'c_files', '1'),
(8, '1', 'images_parent_guidv4', NULL),
(9, '1', 'files_parent_guidv4', NULL);";