<?php
$db_data['structure']['backend_modules'] = "
CREATE TABLE `backend_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['custom_labels'] = "
CREATE TABLE `custom_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['custom_levels'] = "
CREATE TABLE `custom_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `c_thumbnails` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `teaser` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addition` text DEFAULT NULL,
  `position` text DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `linktext` text DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  `parent_guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `guidv4` (`guidv4`,`language`), KEY `parent_guidv4` (`parent_guidv4`), KEY `guidv4_2` (`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['custom_modules'] = "
CREATE TABLE `custom_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['custom_options'] = "
CREATE TABLE `custom_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_public` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['frontend_labels'] = "
CREATE TABLE `frontend_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['frontend_modules'] = "
CREATE TABLE `frontend_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['frontend_options'] = "
CREATE TABLE `frontend_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_public` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['languages'] = "
CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `iso` varchar(3) NOT NULL,
  `language` varchar(3) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['data']['backend_modules'] = "
INSERT IGNORE INTO`backend_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(4, 4, '0', 'custom', 'Benutzerdefiniert', 'de', '', 'auto_awesome', '1', '1', '1', '1'),
(99, 99, '1', 'frontend', 'Frontend', 'de', NULL, 'local_offer', '1', '1', '1', '0');";

$db_data['data']['custom_options'] = "
INSERT IGNORE INTO`custom_options` (`id`, `c_public`, `title`, `value`) VALUES
(1, '0', 'c_modules', '1'),
(2, '1', 'c_levels', '0'),
(3, '1', 'c_levels_multi', '0'),
(6, '1', 'c_images', '1'),
(7, '1', 'c_files', '1'),
(8, '1', 'images_parent_guidv4', NULL),
(9, '1', 'files_parent_guidv4', NULL);";

$db_data['data']['files_categories'] = "
INSERT IGNORE INTO`files_categories` (`id`, `sortorder`, `c_active`, `language`, `category`, `title`) VALUES
(1, 1, '1', 'de', 'file', 'Datei'),
(2, 2, '1', 'de', 'pdf', 'PDF'),
(3, 3, '1', 'de', 'text', 'Text'),
(4, 4, '1', 'de', 'code', 'Code'),
(5, 5, '1', 'de', 'audio', 'Audio'),
(6, 6, '1', 'de', 'video', 'Video');";

$db_data['data']['frontend_modules'] = "
INSERT IGNORE INTO`frontend_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(1, 1, '1', 'frontend_labels', 'Labels', 'de', NULL, 'local_offer', '1', '1', '1', '1');";

$db_data['data']['frontend_options'] = "
INSERT IGNORE INTO`frontend_options` (`id`, `c_public`, `title`, `value`) VALUES
(1, '0', 'c_modules', '1');";

$db_data['data']['languages'] = "
INSERT IGNORE INTO`languages` (`id`, `sortorder`, `c_active`, `iso`, `language`, `title`) VALUES
(1, 1, '1', 'de', 'de', 'deutsch');";
