<?php
$db_data['structure']['encrypt_labels'] = "
CREATE TABLE `encrypt_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['encrypt_modules'] = "
CREATE TABLE `encrypt_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['structure']['encrypt_log'] = "
CREATE TABLE `encrypt_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `c_plain` enum('0','1') NOT NULL DEFAULT '0',
  `module` varchar(255) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `action` enum('encrypt','decrypt','rotate') NOT NULL,
  `status` enum('pending','encrypted','decrypted','rotated','error') NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`), KEY `table` (`table_name`,`field_name`,`status`), KEY `action` (`action`), KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['data']['encrypt_modules'] = "
INSERT INTO `encrypt_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(1, 1, '1', 'encrypt', 'Verschlüsselung', 'de', '', 'encrypted', '1', '1', '0', '0'),
(2, 2, '1', 'encrypt_log', 'Logfiles', 'de', '', 'database', '1', '1', '0', '0');";



$db_data['data']['encrypt_labels'] = "
INSERT INTO `encrypt_labels` (`id`, `c_active`, `language`, `label`, `text`) VALUES
(1, '1', 'de', 'LABEL_MODULE', 'Modul'),
(2, '1', 'de', 'LABEL_ENCRYPTED_FIELDS', 'verschlüsselte Felder'),
(3, '1', 'de', 'LABEL_ENCRYPT', 'Verschlüsseln'),
(4, '1', 'de', 'LABEL_PLAIN', 'Plain'),
(5, '1', 'de', 'LABEL_ROTATION', 'Schlüssel Rotation'),
(6, '1', 'de', 'LABEL_DECRYPT', 'Entschlüsseln'),
(7, '1', 'de', 'LABEL_ERROR_NO_CHANGES', 'Keine änderungen!'),
(8, '1', 'de', 'LABEL_ERROR_PROCESS_RUNNING', 'Daten werden bereits bearbeitet!'),
(9, '1', 'de', 'LABEL_TABLE_NAME', 'Tabellenname'),
(10, '1', 'de', 'LABEL_FIELD_NAME', 'Feldname'),
(11, '1', 'de', 'LABEL_ACTION', 'Aktion'),
(12, '1', 'de', 'LABEL_STATUS', 'Status');";


$db_data['data']['backend_modules'] = "
INSERT IGNORE INTO`backend_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(101, 101, '1', 'encrypt', 'Verschlüsselung', 'de', NULL, 'encrypted', '1', '1', '0', '0');";