<?php
$db_data['structure']['files'] = "
CREATE TABLE `files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `filesize` int(11) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['files_categories'] = "
CREATE TABLE `files_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `title` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['files_levels'] = "
CREATE TABLE `files_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `c_thumbnails` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `teaser` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addition` text DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `linktext` text DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  `parent_guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `guidv4` (`guidv4`,`language`), KEY `parent_guidv4` (`parent_guidv4`), KEY `guidv4_2` (`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['files_levels_links'] = "
CREATE TABLE `files_levels_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_module` int(11) DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `id_module` (`id_module`,`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['images'] = "
CREATE TABLE `images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `filesize` int(11) DEFAULT NULL,
  `text` text DEFAULT NULL,
  `source` text DEFAULT NULL,
  `copyright` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['images_levels'] = "
CREATE TABLE `images_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `c_thumbnails` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `teaser` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addition` text DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `linktext` text DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  `parent_guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `guidv4` (`guidv4`,`language`), KEY `parent_guidv4` (`parent_guidv4`), KEY `guidv4_2` (`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['images_levels_links'] = "
CREATE TABLE `images_levels_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_module` int(11) DEFAULT NULL,
  `guidv4` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `id_module` (`id_module`,`guidv4`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['structure']['library_labels'] = "
CREATE TABLE `library_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['library_modules'] = "
CREATE TABLE `library_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['library_options'] = "
CREATE TABLE `library_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_public` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['data']['backend_modules'] = "
INSERT IGNORE INTO`backend_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(11, 11, '1', 'library', 'Bibliothek', 'de', NULL, 'perm_media', '1', '1', '1', '1');";

$db_data['data']['library_labels'] = "
INSERT IGNORE INTO`library_labels` (`id`, `c_active`, `language`, `label`, `text`) VALUES
(1, '1', 'de', 'LABEL_NEW_FOLDER', 'neuer Ordner'),
(2, '1', 'de', 'LABEL_CATEGORIES', 'Kategorien'),
(3, '1', 'de', 'LABEL_OPTIONS_C_LEVELS_IMAGES', 'Ebenen Bilder'),
(4, '1', 'de', 'LABEL_OPTIONS_C_LEVELS_FILES', 'Ebenen Dateien');";

$db_data['data']['library_modules'] = "
INSERT IGNORE INTO`library_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(1, 1, '1', 'images', 'Bilder', 'de', NULL, 'image', '1', '1', '1', '1'),
(2, 2, '1', 'files', 'Dateien', 'de', NULL, 'insert_drive_file', '1', '1', '1', '1');";

$db_data['data']['library_options'] = "
INSERT IGNORE INTO`library_options` (`id`, `c_public`, `title`, `value`) VALUES
(1, '0', 'c_modules', '1'),
(2, '1', 'c_levels_images', '1'),
(3, '1', 'c_levels_files', '1');";