<?php
$db_data['structure']['settings_labels'] = "
CREATE TABLE `settings_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `language` varchar(3) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`), UNIQUE KEY `language` (`language`,`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['settings_modules'] = "
CREATE TABLE `settings_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sortorder` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `language` varchar(3) DEFAULT NULL,
  `level_module` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `c_cms` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['settings_options'] = "
CREATE TABLE `settings_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_public` enum('0','1') NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

$db_data['structure']['settings_users'] = "
CREATE TABLE `settings_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` int(11) DEFAULT NULL,
  `c_active` enum('0','1') NOT NULL DEFAULT '0',
  `c_admin` enum('0','1') NOT NULL DEFAULT '0',
  `c_editor` enum('0','1') NOT NULL DEFAULT '0',
  `c_viewer` enum('0','1') NOT NULL DEFAULT '0',
  `c_context` enum('0','1') NOT NULL DEFAULT '0',
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `addressline1` varchar(255) DEFAULT NULL,
  `addressline2` varchar(255) DEFAULT NULL,
  `zip` varchar(6) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `language` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";


$db_data['data']['backend_modules'] = "
INSERT IGNORE INTO`backend_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(100, 100, '1', 'settings', 'Einstellungen', 'de', NULL, 'settings', '1', '1', '0', '0');";



$db_data['data']['settings_labels'] = "
INSERT IGNORE INTO`settings_labels` (`id`, `c_active`, `language`, `label`, `text`) VALUES
(1, '1', 'de', 'LABEL_NO_PERMISSION', 'Keine Berechtigung'),
(2, '1', 'de', 'HEADLINE_LOGIN', 'Anmeldung'),
(3, '1', 'de', 'LABEL_LOGINNAME', 'Login'),
(4, '1', 'de', 'LABEL_PASSWORD', 'Passwort'),
(5, '1', 'de', 'LABEL_ERROR', 'Fehler'),
(6, '1', 'de', 'LABEL_ERROR_LOGIN', 'Benutzername oder Passwort nicht korrekt.'),
(7, '1', 'de', 'LABEL_LOGIN', 'anmelden'),
(8, '1', 'de', 'LABEL_IMPRINT', '<strong>entire media</strong> &middot; Andreas Hahn &middot; Sophienberg 1 &middot; D-95028 Hof'),
(9, '1', 'de', 'LABEL_LOGGED_IN', 'Angemeldet als'),
(10, '1', 'de', 'LABEL_EDIT', 'bearbeiten'),
(11, '1', 'de', 'LABEL_LOGOUT', 'abmelden'),
(12, '1', 'de', 'LABEL_FILTER', 'Filter'),
(13, '1', 'de', 'LABEL_LANGUAGE', 'Sprache'),
(14, '1', 'de', 'LABEL_SEARCH', 'Suche'),
(15, '1', 'de', 'LABEL_ACTIVATED', 'Freigabe'),
(16, '1', 'de', 'LABEL_NO', 'nein'),
(17, '1', 'de', 'LABEL_YES', 'ja'),
(18, '1', 'de', 'LABEL_DO_FILTER', 'filtern'),
(19, '1', 'de', 'LABEL_DRAG_UPLOAD', 'Dateien für Upload bereitstellen'),
(20, '1', 'de', 'LABEL_MULTI_ACTIVATE', 'Mehrfachauswahl aktivieren'),
(21, '1', 'de', 'LABEL_MULTI_DEACTIVATE', 'Mehrfachauswahl deaktivieren'),
(22, '1', 'de', 'LABEL_MULTI_DELETE', 'Mehrfachauswahl löschen'),
(23, '1', 'de', 'LABEL_QUICK_EDIT', 'schnell bearbeiten'),
(24, '1', 'de', 'LABEL_NEW_ENTRY', 'neuer Eintrag'),
(25, '1', 'de', 'LABEL_LABEL', 'Label'),
(26, '1', 'de', 'LABEL_TEXT', 'Text'),
(27, '1', 'de', 'LABEL_DEACTIVATE', 'deaktivieren'),
(28, '1', 'de', 'LABEL_ACTIVATE', 'aktivieren'),
(29, '1', 'de', 'LABEL_COPY', 'kopieren'),
(30, '1', 'de', 'LABEL_DELETE', 'löschen'),
(31, '1', 'de', 'LABEL_ERROR_MANDATORY', 'Bitte alle Pflichtfelder ausfüllen!'),
(32, '1', 'de', 'LABEL_DATA', 'Daten'),
(33, '1', 'de', 'LABEL_SAVE', 'speichern'),
(34, '1', 'de', 'LABEL_NOTE', 'Hinweis'),
(35, '1', 'de', 'TEXT_NOTE', 'Felder mit * sind Pflichtfelder.'),
(36, '1', 'de', 'LABEL_DEFAULT_EDITOR', 'Standard'),
(37, '1', 'de', 'LABEL_RICHTEXT_EDITOR', 'Rich-Text'),
(38, '1', 'de', 'LABEL_CODE_EDITOR', 'Code'),
(39, '1', 'de', 'LABEL_SUCCESS_SAVE', 'Daten wurden gespeichert.'),
(40, '1', 'de', 'LABEL_ERROR_SAVE', 'Daten wurden nicht gespeichert.'),
(41, '1', 'de', 'LABEL_ENTER_DATA', 'Daten eingeben'),
(42, '1', 'de', 'LABEL_LOGO', 'Logo'),
(43, '1', 'de', 'LABEL_WATERMARK', 'Wasserzeichen'),
(44, '1', 'de', 'LABEL_LANGUAGES', 'Sprachen'),
(45, '1', 'de', 'LABEL_TITLE', 'Titel'),
(46, '1', 'de', 'LABEL_SORTORDER', 'Folge'),
(47, '1', 'de', 'LABEL_MULTI_EDIT', 'Mehrfachauswahl bearbeiten'),
(48, '1', 'de', 'LABEL_DATETIME', 'Datum'),
(49, '1', 'de', 'LABEL_TEASER', 'Teaser'),
(50, '1', 'de', 'LABEL_ADDITION', 'Zusatz'),
(51, '1', 'de', 'LABEL_LINK', 'Link'),
(52, '1', 'de', 'LABEL_LINKTEXT', 'Linktext'),
(53, '1', 'de', 'LABEL_THUMBNAILS', 'Thumbnails'),
(54, '1', 'de', 'LABEL_ISO', 'ISO'),
(55, '1', 'de', 'LABEL_ERROR_ID_EXISTS', 'ID existiert bereits.'),
(56, '1', 'de', 'LABEL_ID', 'ID'),
(57, '1', 'de', 'LABEL_LASTNAME', 'Nachname'),
(58, '1', 'de', 'LABEL_FIRSTNAME', 'Vorname'),
(59, '1', 'de', 'LABEL_USERNAME', 'Benutzername'),
(60, '1', 'de', 'LABEL_EMAIL', 'E-Mail'),
(61, '1', 'de', 'LABEL_ADDRESSLINE1', 'Adresszeile 1'),
(62, '1', 'de', 'LABEL_ADDRESSLINE2', 'Adresszeile 2'),
(63, '1', 'de', 'LABEL_ZIP_CITY', 'Postleitzahl/Ort'),
(64, '1', 'de', 'LABEL_STATE', 'Staat'),
(65, '1', 'de', 'LABEL_COUNTRY', 'Land'),
(66, '1', 'de', 'LABEL_MONITOR', 'Monitor'),
(67, '1', 'de', 'LABEL_EDITOR', 'Editor'),
(68, '1', 'de', 'LABEL_ADMINISTRATOR', 'Administrator'),
(69, '1', 'de', 'LABEL_CLASS', 'Class'),
(70, '1', 'de', 'LABEL_LEVEL_MODULE', 'Ebenenmodul'),
(71, '1', 'de', 'LABEL_PARENT_MODULE', 'Elternelement'),
(72, '1', 'de', 'LABEL_PERMISSIONS', 'Berechtigungen'),
(73, '1', 'de', 'LABEL_CMS', 'Backend'),
(74, '1', 'de', 'LABEL_ICON', 'Icon'),
(75, '1', 'de', 'LABEL_URL', 'URL'),
(76, '1', 'de', 'LABEL_CONTENT', 'Text'),
(77, '1', 'de', 'LABEL_LEVEL', 'Ebene'),
(78, '1', 'de', 'LABEL_LEVELS', 'Ebenen'),
(79, '1', 'de', 'LABEL_FILE', 'Datei'),
(80, '1', 'de', 'LABEL_CHOOSE_FILE', 'Datei auswählen'),
(81, '1', 'de', 'LABEL_SOURCE', 'Quelle'),
(82, '1', 'de', 'LABEL_COPYRIGHT', 'Copyright'),
(83, '1', 'de', 'LABEL_POSITION', 'Position'),
(84, '1', 'de', 'LABEL_OUTER', 'außen'),
(85, '1', 'de', 'LABEL_INNER', 'innen'),
(86, '1', 'de', 'LABEL_ENLARGE', 'vergrößern'),
(87, '1', 'de', 'LABEL_CATEGORY', 'Kategorie'),
(88, '1', 'de', 'LABEL_GUIDV4', 'GUIDV4'),
(89, '1', 'de', 'LABEL_NO_RESULTS', 'Keine Suchergebnisse gefunden.'),
(90, '1', 'de', 'LABEL_SETTINGS', 'Einstellungen'),
(91, '1', 'de', 'LABEL_MODULES', 'Module'),
(92, '1', 'de', 'LABEL_POSITION_TOP', 'Navigation oben'),
(93, '1', 'de', 'LABEL_POSITION_BOTTOM', 'Navigation unten'),
(94, '1', 'de', 'LABEL_POSITION_MAIN', 'Hauptnavigation'),
(95, '1', 'de', 'LABEL_POSITION_MOBILE', 'Mobile Navigation'),
(96, '1', 'de', 'LABEL_POSITION_WIDGET', 'Widget'),
(97, '1', 'de', 'LABEL_POSITION_SITEMAP', 'Sitemap'),
(98, '1', 'de', 'LABEL_IMAGES_LEVEL', 'Bildordner'),
(99, '1', 'de', 'LABEL_FILES_LEVEL', 'Dateiordner'),
(100, '1', 'de', 'LABEL_CHOOSE', 'Medien auswählen'),
(101, '1', 'de', 'LABEL_UPLOAD', 'Medien hochladen'),
(102, '1', 'de', 'LABEL_REMOVE_MEDIA', 'Medien entfernen'),
(103, '1', 'de', 'LABEL_REMOVE', 'entfernen'),
(104, '1', 'de', 'LABEL_GRID', 'Kachelansicht'),
(105, '1', 'de', 'LABEL_LIST', 'Listenansicht'),
(106, '1', 'de', 'LABEL_FILESIZE', 'Dateigröße'),
(107, '1', 'de', 'LABEL_SUCCESS', 'Erfolgreich'),
(108, '1', 'de', 'LABEL_USE_FILES', 'Verwenden'),
(109, '1', 'de', 'LABEL_CLOCK', 'Uhr'),
(110, '1', 'de', 'LABEL_OUTSIDE', 'Außen'),
(111, '1', 'de', 'LABEL_INSIDE', 'Innen'),
(112, '1', 'de', 'LABEL_ADOPT', 'übernehmen'),
(113, '1', 'de', 'LABEL_IMAGES', 'Bilder'),
(114, '1', 'de', 'LABEL_FILES', 'Dateien'),
(115, '1', 'de', 'LABEL_BACK', 'zurück'),
(116, '1', 'de', 'LABEL_FILEPATH', 'Dateipfad'),
(117, '1', 'de', 'LABEL_OPTIONS_C_LEVELS', 'Ebenen'),
(118, '1', 'de', 'LABEL_OPTIONS_C_LEVELS_MULTI', 'Ebenenmehrfachauswahl'),
(119, '1', 'de', 'LABEL_OPTIONS_TITLE_PAGE', 'Seitenname'),
(120, '1', 'de', 'LABEL_OPTIONS_DIFFERENCE_DAYS', 'Differenz Suche'),
(121, '1', 'de', 'LABEL_ERROR_FILE_TYPE', 'Falscher Dateityp'),
(122, '1', 'de', 'LABEL_OPTIONS_C_IMAGES', 'Bilder'),
(123, '1', 'de', 'LABEL_OPTIONS_C_FILES', 'Dateien'),
(124, '1', 'de', 'LABEL_OPTIONS_THUMBNAIL', 'Thumbnail'),
(125, '1', 'de', 'LABEL_OPTIONS_THUMBNAILS', 'Thumbnails'),
(126, '1', 'de', 'LABEL_OPTIONS', 'Optionen'),
(129, '1', 'de', 'LABEL_LABELS', 'Labels'),
(130, '1', 'de', 'LABEL_CONTEXT', 'Context Menü'),
(131, '1', 'de', 'LABEL_OPTIONS_ADD', 'hinzufügen');";

$db_data['data']['settings_modules'] = "
INSERT IGNORE INTO`settings_modules` (`id`, `sortorder`, `c_active`, `title`, `text`, `language`, `level_module`, `icon`, `c_cms`, `c_admin`, `c_editor`, `c_viewer`) VALUES
(1, 1, '1', 'settings_users', 'Benutzer', 'de', '', 'person', '1', '1', '1', '1');";

$db_data['data']['settings_options'] = "
INSERT IGNORE INTO`settings_options` (`id`, `c_public`, `title`, `value`) VALUES
(1, '1', 'title_page', 'Comator | [DOMAIN]'),
(2, '0', 'logo', 'logo.png'),
(3, '1', 'difference_days', '365'),
(4, '0', 'c_modules', '1');";

$db_data['data']['settings_users'] = "
INSERT IGNORE INTO`settings_users` (`id`, `datetime`, `c_active`, `c_admin`, `c_editor`, `c_viewer`, `c_context`, `username`, `password`, `email`, `firstname`, `lastname`, `addressline1`, `addressline2`, `zip`, `city`, `state`, `country`, `language`) VALUES
(1, 1697541420, '1', '1', '1', '1', '0', 'nd', '3d8629730738a770c12d52771d9da570', 'hahn@entire-media.de', 'Andreas', 'Hahn', '', '', '', '', '', '', 'de'),
(2, 1697499180, '1', '1', '1', '1', '0', 'devil', '8f0076a1e8baefc5b9c3ae5f4bccaa90', 'ulbig@entire-media.de', 'Sebastian', 'Ulbig', '', '', '', '', '', '', 'de');";