<?php
date_default_timezone_set('Europe/Berlin'); 
function database_connect($db = array()){
	try {
		$dbh = 'mysql:host='.$db['host'].';dbname='.$db['dbname'];
		$pd = new PDO($dbh, $db['user'], $db['pass'], array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8mb4', PDO::ATTR_PERSISTENT => true));
		$pd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$pd->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);
		$pd->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
		return $pd;
	} catch (PDOException $e) {
		db_exception_log($e->getMessage());
	}
}

function db_exception_log($message , $sql = ''){
	$exception  = 'Unhandled Exception. <br />';
	$exception .= $message;
	$exception .= "<br /> You can find the error back in the log.";
	if(!empty($sql)) {
		$exception .= "\r\nRaw SQL : "  . $sql;
	}
	return $exception;
}

function check_table($table){
	global $conn;
	$result = $conn->query("SHOW TABLES");
	while ($arr = $result->fetch(PDO::FETCH_COLUMN)){
		if ($arr == $table){
			return $arr;
		}
	}
	return false;
}

function check_column($table, $column){
	global $conn;
	$sql = "SHOW COLUMNS FROM ".$table." LIKE :column";
	$result = $conn->prepare($sql);
	$result->bindValue(':column', $column);
	$result->execute();
	return $result->rowCount() > 0;
}