<?php

$file_dir = '../images/';
if (!is_dir($file_dir)) mkdir($file_dir);
$module_dir = $file_dir.$backend_module."/";
if (!is_dir($module_dir)) mkdir($module_dir);

$resolutions_data = array();
foreach (get_defined_vars() AS $var => $value){
	if (str_starts_with($var, 'image_width_') OR str_starts_with($var, 'image_height_')){
		$key = str_replace('image_width_', '', str_replace('image_height_', '', $var));
		if (str_starts_with($var, 'image_width_') && $value) $resolutions_data[$key]['width'] = intval($value);
		else if (str_starts_with($var, 'image_width_')) $resolutions_data[$key]['width'] = NULL;
		else if (str_starts_with($var, 'image_height_') && $value) $resolutions_data[$key]['height'] = intval($value);
		else if (str_starts_with($var, 'image_height_')) $resolutions_data[$key]['height'] = NULL;
	}
}

$images_remove = array();
$sql_sub = "SELECT images.file, module.id_media FROM ".$module."_images AS module 
						LEFT JOIN images AS images ON module.id_media = images.id 
						WHERE id_module = :id GROUP BY images.file ";
$result_sub = $conn->prepare($sql_sub);
$result_sub->bindValue(':id', $id, PDO::PARAM_INT);
$result_sub->execute();
if ($result_sub->rowCount()){
	while ($arr_sub = $result_sub->fetch()){
		$sql_check = "SELECT id_media FROM ".$module."_images WHERE id_media = :id_media AND id_module != :id LIMIT 1";
		$result_check = $conn->prepare($sql_check);
		$result_check->bindValue(':id_media', $arr_sub['id_media'], PDO::PARAM_INT);
		$result_check->bindValue(':id', $id, PDO::PARAM_INT);
		$result_check->execute();
		if (!$result_check->rowCount()) $images_remove[$arr_sub['id_media']] = $arr_sub['file'];
	}
}

$sql_sub = "DELETE FROM ".$module."_images WHERE id_module = :id ";
$result_sub = $conn->prepare($sql_sub);
$result_sub->bindValue(':id', $id, PDO::PARAM_INT);
$result_sub->execute();
if (isset($images_data) && is_array($images_data)){
	foreach ($images_data AS $key => $value){
		if (isset($images_remove[$value['id_media']]) && $images_remove[$value['id_media']]) {
			unset($images_remove[$value['id_media']]);
		}
		
		$sql_check = "SELECT file FROM images WHERE id = :id LIMIT 1";
		$result_check = $conn->prepare($sql_check);
		$result_check->bindValue(':id', $value['id_media'], PDO::PARAM_INT);
		$result_check->execute();
		if ($result_check->rowCount()){
			$arr_check = $result_check->fetch();
			$sql_tmp = "INSERT INTO ".$module."_images SET 
									id_module = :id, 
									id_media = :id_media,
									sortorder = :sortorder ";
			if (isset($value['title']) && $value['title']) $sql_tmp .= ", title = :title ";
			else $sql_tmp .= ", title = NULL ";
			if (isset($value['alt']) && $value['alt']) $sql_tmp .= ", alt = :alt ";
			else $sql_tmp .= ", alt = NULL ";
			if (isset($value['photographer']) && $value['photographer']) $sql_tmp .= ", photographer = :photographer ";
			else $sql_tmp .= ", photographer = NULL ";
			if (isset($value['text']) && $value['text']) $sql_tmp .= ", text = :text ";
			else $sql_tmp .= ", text = NULL ";
			if (isset($value['source']) && $value['source']) $sql_tmp .= ", source = :source ";
			else $sql_tmp .= ", source = NULL ";
			if (isset($value['copyright']) && $value['copyright']) $sql_tmp .= ", copyright = :copyright ";
			else $sql_tmp .= ", copyright = NULL ";
			if (isset($value['link']) && $value['link']) $sql_tmp .= ", link = :link ";
			else $sql_tmp .= ", link = NULL ";
			if (isset($value['linktext']) && $value['linktext']) $sql_tmp .= ", linktext = :linktext ";
			else $sql_tmp .= ", linktext = NULL ";
			if (isset($value['r_position_outside']) && $value['r_position_outside']) $sql_tmp .= ", r_position_outside = :r_position_outside ";
			else $sql_tmp .= ", r_position_outside = NULL ";
			if (isset($value['r_position_inside']) && $value['r_position_inside']) $sql_tmp .= ", r_position_inside = :r_position_inside ";
			else $sql_tmp .= ", r_position_inside = NULL ";
			if (isset($value['c_enlarge']) && $value['c_enlarge']) $sql_tmp .= ", c_enlarge = :c_enlarge ";
			else $sql_tmp .= ", c_enlarge = '0' ";
			
			$result_tmp = $conn->prepare($sql_tmp);
			$result_tmp->bindValue(':id', $id, PDO::PARAM_INT);
			$result_tmp->bindValue(':id_media', $value['id_media'], PDO::PARAM_INT);
			$result_tmp->bindValue(':sortorder', $value['sortorder'], PDO::PARAM_INT);
			if (isset($value['title']) && $value['title']) $result_tmp->bindValue(':title', $value['title'], PDO::PARAM_STR);
			if (isset($value['alt']) && $value['alt']) $result_tmp->bindValue(':alt', $value['alt'], PDO::PARAM_STR);
			if (isset($value['photographer']) && $value['photographer']) $result_tmp->bindValue(':photographer', $value['photographer'], PDO::PARAM_STR);
			if (isset($value['text']) && $value['text']) $result_tmp->bindValue(':text', $value['text'], PDO::PARAM_STR);
			if (isset($value['source']) && $value['source']) $result_tmp->bindValue(':source', $value['source'], PDO::PARAM_STR);
			if (isset($value['copyright']) && $value['copyright']) $result_tmp->bindValue(':copyright', $value['copyright'], PDO::PARAM_STR);
			if (isset($value['link']) && $value['link']) $result_tmp->bindValue(':link', $value['link'], PDO::PARAM_STR);
			if (isset($value['linktext']) && $value['linktext']) $result_tmp->bindValue(':linktext', $value['linktext'], PDO::PARAM_STR);
			if (isset($value['r_position_outside']) && $value['r_position_outside']) $result_tmp->bindValue(':r_position_outside', $value['r_position_outside'], PDO::PARAM_STR);
			if (isset($value['r_position_inside']) && $value['r_position_inside']) $result_tmp->bindValue(':r_position_inside', $value['r_position_inside'], PDO::PARAM_STR);
			if (isset($value['c_enlarge']) && $value['c_enlarge']) $result_tmp->bindValue(':c_enlarge', $value['c_enlarge'], PDO::PARAM_STR);
			
			$result_tmp->execute();
			
			if ((isset($lightbox_width) && $lightbox_width) OR (isset($lightbox_height) && $lightbox_height)){
				$width = NULL;
				$height = NULL;
				if (isset($lightbox_width) && $lightbox_width) $width = $lightbox_width;
				if (isset($lightbox_height) && $lightbox_height) $height = $lightbox_height;
				if (!is_dir($module_dir.'lightbox/')) mkdir($module_dir.'lightbox/');
				if (!is_file($module_dir.'lightbox/'.$arr_check['file'])){
					resize($file_dir.'original/'.$arr_check['file'], $module_dir.'lightbox/'.$arr_check['file'], $width, $height, $c_lightbox_watermark);
					chmod($module_dir.'lightbox/'.$arr_check['file'], 0644);
				}
			}
			
			foreach ($resolutions_data AS $thumb => $resolution){
				$width = NULL;
				$height = NULL;
				if (isset($resolution['width']) && $resolution['width']) $width = $resolution['width'];
				if (isset($resolution['height']) && $resolution['height']) $height = $resolution['height'];
				if (!is_dir($module_dir.'thumb'.$thumb.'/')) mkdir($module_dir.'thumb'.$thumb.'/');
				if (!is_file($module_dir.'thumb'.$thumb.'/'.$arr_check['file'])){
					resize($file_dir.'original/'.$arr_check['file'], $module_dir.'thumb'.$thumb.'/'.$arr_check['file'], $width, $height, $c_thumbnails_watermark);
					chmod($module_dir.'thumb'.$thumb.'/'.$arr_check['file'], 0644);
				}
			}
			
		}
		
	}
}
if (isset($images_remove) && is_array($images_remove)){
	if ((isset($lightbox_width) && $lightbox_width) OR (isset($lightbox_height) && $lightbox_height)){
		foreach ($images_remove AS $file){
			if (is_file($module_dir.'lightbox/'.$file)) {
				unlink($module_dir.'lightbox/'.$file);
			}
		}
		if (is_dir_empty($module_dir.'lightbox/')){
			rmdir($module_dir.'lightbox/');
		}
		if (is_dir_empty($module_dir)){
			rmdir($module_dir);
		}
	}
	foreach ($resolutions_data AS $thumb => $resolution){
		foreach ($images_remove AS $file){
			if (is_file($module_dir.'thumb'.$thumb.'/'.$file)) {
				unlink($module_dir.'thumb'.$thumb.'/'.$file);
			}
		}
		if (is_dir_empty($module_dir.'thumb'.$thumb.'/')){
			rmdir($module_dir.'thumb'.$thumb.'/');
		}
		if (is_dir_empty($module_dir)){
			rmdir($module_dir);
		}
	}
}