<?php
function resize($src, $dest, $width = NULL, $height = NULL, $stamp = false, $quality = 100, $deg = 0) {	
	$ext_tmp = explode(".", $src);
	$ext = end($ext_tmp);
	  
	$dest_ext_tmp = explode(".", $dest);
	$dest_ext = end($dest_ext_tmp);
	
  $image_size = getimagesize($src);
  $image_width = $image_size[0];
  $image_height = $image_size[1];
  
	if ($quality < 10) $quality = 10;
	if ($quality > 100) $quality = 100;
	
	if (!$width && !$height){
		$width = $image_width;
		$height = $image_height;
	}
	
	if (!$src OR (!$width && !$height)) return false;
	
	if (!$width) $width = $image_width;
	if (!$height) $height = $image_height;
	
	$img_ratio = $image_width/$image_height;
	
	if (($image_width > $width) || ($image_height > $height)) {
		if ($height * $img_ratio > $width) $height = $width / $img_ratio;
		else $width = $height * $img_ratio;
		if ($width / $img_ratio < $height) $height = $width / $img_ratio;
		else $width = $height * $img_ratio;
	} else {
		$width = $image_width;
		$height = $image_height;
	}
	
	if (extension_loaded('gd')) {
		$info = @getimagesize($src);
    if (!$info || !isset($info['mime'])) return false;
    
    
		switch ($info['mime']) {
			case 'image/png': $image = @imagecreatefrompng($src); break;
			case 'image/bmp':	$image = @imagecreatefrombmp($src); break;
			case 'image/webp': $image = @imagecreatefromwebp($src); break;
			case 'image/jpeg': $image = @imagecreatefromjpeg($src); break;
			case 'image/gif':	$image = @imagecreatefromgif($src); break;
		}
	  
	  if ($stamp == true) img_add_watermark($image);
	  
	  $width = (int) $width;
	  $height = (int) $height;
	  $image_width = (int) $image_width;
	  $image_height = (int) $image_height;
	  
	  $thumb = imagecreatetruecolor($width, $height);
	  if ($ext == 'png' || $ext == 'webp'){
	  	imagealphablending($thumb, false);
			imagesavealpha($thumb, true);
		}
	  imagecopyresampled($thumb, $image, 0, 0, 0, 0, $width, $height, $image_width, $image_height);
	  
		switch ($dest_ext){
			case 'png':
				$quality = ($quality - 100) / 11.111111;
				$quality = round(abs($quality));
				imagepng($thumb, $dest, $quality);
				break;
			case 'bmp': imagebmp($thumb, $dest, $quality); break;
			case 'webp': imagewebp($thumb, $dest, $quality); break;
			case 'jpg': imagejpeg($thumb, $dest, $quality); break;
			case 'jpeg': imagejpeg($thumb, $dest, $quality); break;
			case 'gif': imagegif($thumb, $dest, $quality); break;
		}
	  imagedestroy($image);
	  imagedestroy($thumb);
	  return true;
	} elseif (extension_loaded('imagick')){
		$imagick = new Imagick();
		$imagick->readImage($src);
		$imagick->resizeImage($width, $height, Imagick::FILTER_LANCZOS, 1, 1);
		$imagick->setImageCompressionQuality($quality);
	  $imagick->writeImage($dest);
	  $imagick->clear();
	  $imagick->destroy();
	  return true;
	} else {
		$fehler = LABEL_ERROR_IMAGE_LIB;
	  return false;
	}
}


function img_add_watermark($thumb) {
	global $watermark, $watermark_position, $watermark_top, $watermark_right, $watermark_bottom, $watermark_left;
	
	$width = imagesx($thumb);
	$height = imagesy($thumb);
	
	if (!$watermark_top) $watermark_top = 0;
	if (!$watermark_right) $watermark_right = 0;
	if (!$watermark_bottom) $watermark_bottom = 0;
	if (!$watermark_left) $watermark_left = 0;
	
	if (extension_loaded('gd') && is_file("images/".$watermark)) {
		$watermark_file = imagecreatefrompng("images/".$watermark);
		
  	$image_width = imagesx($watermark_file);
  	$image_height = imagesy($watermark_file);
  	
  	switch ($watermark_position){
  		case 'RT':
  			$watermark_x = $width - $image_width - $watermark_right;
  			$watermark_y = 0 + $watermark_top;
  			break;
  		case 'RB':
  			$watermark_x = $width - $image_width - $watermark_right;
  			$watermark_y = $height - $image_height - $watermark_bottom;
  			break;
  		case 'LB':
  			$watermark_x = 0 + $watermark_left;
  			$watermark_y = $height - $image_height - $watermark_bottom;
  			break;
  		case 'LT':
  		default:
  			$watermark_x = 0 + $watermark_left;
  			$watermark_y = 0 + $watermark_top;
  			break;
  	}  	
  	
	  $watermark_x = (int) $watermark_x;
	  $watermark_y = (int) $watermark_y;
	  $image_width = (int) $image_width;
	  $image_height = (int) $image_height;
		
		imagecopyresampled ($thumb, $watermark_file, $watermark_x, $watermark_y, 0, 0, $image_width, $image_height, $image_width, $image_height);
	}
}