
function popup(name, url){
	this.name = 'edit_'+name;
	//var $width = window.with - 300;
	tmp = window.open(url, 'form_'+name, 'width=1250,height=900,status=yes,scrollbars=yes,toolbar=yes,location=yes,menubar=yes,resizable=no');
	tmp.focus();
}

function multi_check(){
	
	$(".btn.multiselect").click(function(event){
		event.preventDefault();
		if ($(this).hasClass('active')){
			$('.multicheck:checked').each(function(){
				$(this).click();
			});
			$(this).removeClass('active');
		} else {
			$(this).addClass('active');
		}
	});
	
	$('.c_multicheck').change(function(event){
		$('.multicheck').not(this).prop('checked', this.checked);
		if ($('.multicheck:checked').length) {
			$('.multicheck_control').css('display', 'inline-block');
			$('.btn.select').css('display', 'inline-block');
		} else {
			$('.multicheck_control').hide();
			$('.btn.select').hide();
		}
	});
	
	$('.multicheck').change(function(event){
		if ($('.multicheck:checked').length) {
			$('.multicheck_control').css('display', 'inline-block');
			$('.btn.select').css('display', 'inline-block');
		} else {
			$('.multicheck_control').hide();
			$('.btn.select').hide();
		}
	});
}

function defaults(){
		
	$('body').on('click', '.popup_filter', function(event){
		event.preventDefault();
		var $url = '';
		if ($("#id_template").val()) $url = $url+'&id_template='+$("#id_template").val();
		if ($("#parent_guidv4").val()) $url = $url+'&parent_guidv4='+$("#parent_guidv4").val();
		if ($("#language").val()) $url = $url+'&language='+$("#language").val();
		popup('filter_'+$(this).attr('data-module'), 'popup_filter.php?module='+$(this).attr('data-module')+'&backend_module='+$(this).attr('data-backend-module')+$url);
	});
	
	if ($(".popup")){
		$(window).keydown(function(event) {
			if (!(event.which == 83 && event.ctrlKey)) return true;
			$("button[type='submit']").click();
			event.preventDefault();
			return false;
		});
		$('form').submit(function(event) {
			$('.show_default-editor').each(function() {
		    var id = $(this).data('id');
		    var panel = $('.textarea-panel[data-id="'+id+'"]');
		    var def = panel.data('default');
		
		    if (!def || def === 'default') {
		      $(this).click();
		    }
		  });
		  return true;
		});
	}
	
}

function filter(){
	
	$(".reload").change(function(event){
  	$("button[type='submit']").val('reload');
  	$("button[type='submit']").click();
	});
		
	$(".order").click(function(event){
		event.preventDefault();
		var $order = $("input[name='order']").val();
		var $lastorder = $("input[name='lastorder']").val();
		var $orderdir = $("input[name='orderdir']").val();
		if (($(this).attr('data-order') == $lastorder) || ($order != $lastorder)){
			if ($orderdir == 'ASC') $orderdir = 'DESC';
			else $orderdir = 'ASC';
		}
		$("input[name='orderdir']").val($orderdir);
		$("input[name='lastorder']").val($order);
		$("input[name='order']").val($(this).attr('data-order'));
  	$("button[type='submit']").click();
	});
	
	$(".grid").click(function(event){
		event.preventDefault();
		$("input[name='c_grid']").val('1');
  	$("button[type='submit']").click();
	});
	
	$(".list").click(function(event){
		event.preventDefault();
		$("input[name='c_grid']").val('0');
  	$("button[type='submit']").click();
	});
	
	$(".add").click(function(event){
		event.preventDefault();
		var $url = '';
		if ($("#id_template").val()) $url = $url+'&id_template='+$("#id_template").val();
		if ($("#parent_guidv4").val()) $url = $url+'&parent_guidv4='+$("#parent_guidv4").val();
		if ($("#language").val()) $url = $url+'&language='+$("#language").val();
		popup('add_'+$(this).attr('data-module'), 'popup_form.php?module='+$(this).attr('data-module')+'&backend_module='+$(this).attr('data-backend-module')+'&action=add'+$url);
	});
		
	$("body").on('click', ".edit", function(event){
		if (!$(event.target).hasClass('multicheck')){
			event.preventDefault();
	    var $id = $(this).attr('data-id');
			if (!$(this).hasClass('multiselect') && !$(event.target).hasClass('grid-title')){
				var $module = $(this).attr('data-module');
		    var $backend_module = $(this).attr('data-backend-module');
		    var $tab = '';
		    if ($(this).attr('data-tab')) $tab = '&tab='+$(this).attr('data-tab');
				popup('edit_'+$module+'_'+$id, 'popup_form.php?module='+$module+'&backend_module='+$backend_module+'&id='+$id+'&action=edit'+$tab);
			} else {
				$(this).toggleClass('selected');
				$('.multicheck.c_check_'+$id).click();
			}
		}
	});
	
	
	$("body").on('click', ".copy", function(event){
		event.preventDefault();
		
		if ($(this).hasClass('ask')) {
	    if (!confirm('Soll wirklich eine Kopie erstellt werden?')) return;
	  }
	  
		var $module = $(this).attr('data-module');
    var $id = $(this).attr('data-id');	
    var $backend_module = $(this).attr('data-backend-module');
		popup('edit_'+$module+'_'+$id, 'popup_form.php?module='+$module+'&backend_module='+$backend_module+'&id='+$id+'&action=copy');
	});
	
	$("body").on('click', ".activate", function(event){
		event.preventDefault();
		$("input[name='id_active']").val($(this).attr('id'));
  	$("button[type='submit']").click();
	});
	
	$("body").on('click', ".delete", function(event){
		event.preventDefault();
    var $id = $(this).attr('data-id');	
		var $module = $(this).attr('data-module');
		var $backend_module = $(this).attr('data-backend-module');
		var $file = $(this).attr('data-file');
		var check = confirm('Wollen Sie den Eintrag wirklich l\u00f6schen?');
		if (check == true) {
			if ($module && $backend_module){
				var $url = 'ajax.php?module='+$module+'&backend_module='+$backend_module+'&id='+$id;
				if ($file) $url += '&file='+$file;
				$.ajax({
					url: $url,
					type: 'GET',
					success: function(data) {
						var $result = $.parseJSON(data);
						if (!$result.data || $result.data.length === 0){
							$("input[name='id_delete']").val($id);
			  			$("button[type='submit']").click();
						} else {
							const $parts = [];
							if ($result.label_before) $parts.push($result.label_before);
							
							if (Array.isArray($result.data) && $result.data.length) {
							  $parts.push($result.data.map(String).join("\n"));
							}
							
							if ($result.label_after) $parts.push($result.label_after);
							const $msg = $parts.join("\n\n"); 
							
							if (confirm($msg)) {
								$("input[name='id_delete']").val($id);
				  			$("button[type='submit']").click();
							}
						}
					}
				});
			} else {
				$("input[name='id_delete']").val($id);
  			$("button[type='submit']").click();
			}
  	}
	});
	
	$("body").on('click', ".open-action", function(event){
		event.preventDefault();
		var $module = $(this).attr('data-module');
    var $id = $(this).attr('data-id');	
    var $backend_module = $(this).attr('data-backend-module');
		popup('open-action_'+$module+'_'+$id, 'popup_action.php?module='+$module+'&backend_module='+$backend_module+'&id='+$id);
	});
	
	$("body").on('click', ".install_module", function(event){
		event.preventDefault();
    var $module = $(this).attr('data-module');	
		var check = confirm('Wollen Sie das Modul installieren?');
		if (check == true) {
			$("input[name='install_module']").val($module);
  		$("button[type='submit']").click();
  	}
	});
	
	$("body").on('click', ".download_export", function(event){
		event.preventDefault();
		var $module = $(this).attr('data-module');
    var $id = $(this).attr('data-id');	
    var $file = $(this).attr('data-file');	
    var $backend_module = $(this).attr('data-backend-module');
		popup('export-action_'+$module+'_'+$id, 'ajax.php?module='+$module+'&backend_module='+$backend_module+'&file='+$file+'_export&id='+$id);
	});
	
	$("body").on('click', ".update_module", function(event){
		event.preventDefault();
    var $module = $(this).attr('data-module');	
		var check = confirm('Wollen Sie das Modul aktualisieren?');
		if (check == true) {
			$("input[name='update_module']").val($module);
  		$("button[type='submit']").click();
  	}
	});
	
	$(".delete_level").click(function(event){
		event.preventDefault();
    var $id = $(this).attr('data-id');	
		var check = confirm('Wollen Sie den Eintrag wirklich l\u00f6schen?');
		if (check == true) {
			$("input[name='id_delete_level']").val($id);
  		$("button[type='submit']").click();
  	}
	});
	
	$(".btn.export").click(function(event){
		event.preventDefault();
		var check = confirm('Wollen Sie wirklich exportieren?');
		if (check == true) {
			$("input[name='export']").val($(this).attr('data-module'));
	  	$("button[type='submit']").click();
			$("input[name='export']").val('0');
  	}
	});
	
	$(".btn.export-manager").click(function(event){
		event.preventDefault();
		var form = $("form");
		var $module = $(this).attr('data-module');
	  var $backend_module = $(this).attr('data-backend-module');
		var $file = $(this).attr('data-file');
		var $id = $(this).attr('data-id');
		$.fancybox.open({
			type: 'ajax',
			src: 'ajax.php?module='+$module+'&backend_module='+$backend_module+'&file='+$module+'_export',
			opts: {
				touch: false,
				afterLoad: function(instance, current){
				},
				afterShow: function(instance, current){
					$('.start-export').click(function(event){
						event.preventDefault();
						instance.close();
						$("input[name='export_type']").val($('.fancybox-content .form-row').find('[name="export_type"]').val());
						$("input[name='file']").val($('.fancybox-content .form-row').find('[name="file"]').val());
						$("input[name='c_labels']").val($('.fancybox-content .form-row').find('[name="c_labels"]').attr('checked'));
						$("input[name='export']").val($module);
				  	$("button[type='submit']").click();
						$("input[name='export']").val('0');
					});
				}
			}
		});
	});
	
	$(".btn.import").click(function(event){
		event.preventDefault();
		var $module = $(this).attr('data-module');
    var $backend_module = $(this).attr('data-backend-module');
		popup('import_'+$module, 'popup_form.php?module=import_'+$module+'&backend_module='+$backend_module);
	});
}

function filter_multi(){
	
	$(".multi_activate").click(function(event){
		event.preventDefault();
		var check = confirm('Wollen Sie die Eintr\u00e4ge wirklich aktivieren?');
		if (check == true) {
			$("input[name='multi_activate']").val(1);
	  	$("button[type='submit']").click();
	  }
	});
	
	$(".multi_deactivate").click(function(event){
		event.preventDefault();
		var check = confirm('Wollen Sie die Eintr\u00e4ge wirklich deaktivieren?');
		if (check == true) {
			$("input[name='multi_deactivate']").val(1);
	  	$("button[type='submit']").click();
	  }
	});
	
	$(".multi_edit").click(function(event){
		event.preventDefault();
		var $module = $(this).attr('data-module');
    var $backend_module = $(this).attr('data-backend-module');
		var $id_list = null;
		$('.multicheck:checked').each(function(){
			if ($id_list == null) $id_list = $(this).attr('id').replace('c_check_', '');
			else $id_list = $id_list+','+$(this).attr('id').replace('c_check_', '');
		});
		popup('multi_'+$module+'_'+$id_list, 'popup_form.php?module='+$module+'_multi&backend_module='+$backend_module+'&multi_module='+$module+'&ids='+$id_list);
	});
	
	$(".multi_delete").click(function(event){
		event.preventDefault();
		var form = $("form")
		var $module = $(this).attr('data-module');
		var $backend_module = $(this).attr('data-backend-module');
		var $file = $(this).attr('data-file');
		var check = confirm('Wollen Sie die Eintr\u00e4ge wirklich l\u00f6schen?');
		if (check == true) {
			if ($module && $backend_module){
				var $url = 'ajax.php?module='+$module+'&backend_module='+$backend_module;
				if ($file) $url += '&file='+$file;
				$.ajax({
					url: $url,
					type: 'POST',
					data: form.serialize(),
					success: function(data) {
						var $result = $.parseJSON(data);
						if (!$result.data || $result.data.length === 0){
							$("input[name='multi_delete']").val(1);
					  	$("button[type='submit']").click();
						} else {
							const $parts = [];
							if ($result.label_before) $parts.push($result.label_before);
							
							if (Array.isArray($result.data) && $result.data.length) {
							  $parts.push($result.data.map(String).join("\n"));
							}
							
							if ($result.label_after) $parts.push($result.label_after);
							const $msg = $parts.join("\n\n"); 
							
							if (confirm($msg)) {
								$("input[name='multi_delete']").val(1);
						  	$("button[type='submit']").click();
							}
						}
					}
				});
			} else {
				$("input[name='multi_delete']").val(1);
		  	$("button[type='submit']").click();
		  }
	  }
	});
	
	
	$(".multi_open-action").click(function(event){
		event.preventDefault();
		var $module = $(this).attr('data-module');
    var $backend_module = $(this).attr('data-backend-module');
		var $id_list = null;
		$('.multicheck:checked').each(function(){
			if ($id_list == null) $id_list = $(this).attr('id').replace('c_check_', '');
			else $id_list = $id_list+','+$(this).attr('id').replace('c_check_', '');
		});
		popup('multi_open-action_'+$module+'_'+$id, 'popup_action.php?module='+$module+'&backend_module='+$backend_module+'&ids='+$id);
	});
}

function context_menu(){
	$('.table-body:not(.no-context) .table-cell:not(.c_active):not(.toolbar):not(.multiselect):not(.folder), .table-grid:not(.no-context) .table-cell:not(.c_active):not(.toolbar):not(.multiselect):not(.folder)').unbind('contextmenu');
	$('.holder.edit').unbind('contextmenu');
	$('.context-menu').unbind('contextmenu');
		
	$('.table-body:not(.no-context) .table-cell:not(.c_active):not(.toolbar):not(.multiselect):not(.folder), .table-grid:not(.no-context) .table-cell:not(.c_active):not(.toolbar):not(.multiselect):not(.folder)').bind('contextmenu', function (e) {
		var $module = $(this).parents('.table-row').attr('data-module');
    var $backend_module = $(this).parents('.table-row').attr('data-backend-module');
    var $id = $(this).parents('.table-row').attr('data-id');
    var $file = $(this).parents('.table-row').attr('data-file');
		if ($(this).parents('.table-grid').length > 0){
			$module = $(this).attr('data-module');
	    $backend_module = $(this).attr('data-backend-module');
    	$id = $(this).attr('data-id');	
    	$file = $(this).attr('data-file');	
    }	
    
    var top = e.pageY+5;
    var left = e.pageX;
    
    $('.context-menu li').each(function(e){
    	$(this).children('a').attr('data-module', $module).attr('data-backend-module', $backend_module).attr('data-id', $id).attr('data-file', $file);
    });

		$('.context-menu').toggle(100).css({
		   top: top + "px",
		   left: left + "px"
		});
		
		return false;
  });
  
	$('.holder.edit').bind('contextmenu', function (e) {
		var $module = $(this).attr('data-module');
    var $backend_module = $(this).attr('data-backend-module');
    var $id = $(this).attr('data-id');
    
    var top = e.pageY+5;
    var left = e.pageX;
    
    $('.context-menu li').each(function(e){
    	$(this).children('a').attr('data-module', $module).attr('data-backend-module', $backend_module).attr('data-id', $id);
    });

		$('.context-menu').toggle(100).css({
		   top: top + "px",
		   left: left + "px"
		});
		
		return false;
  });

  $(document).bind('contextmenu click',function(){
    $('.context-menu').hide();
  });

	$('.context-menu').bind('contextmenu',function(){
	   return false;
	});
}

function quick_edit(){
	
	$('body').on('dblclick', '.quick', function() {
		if ($(this).hasClass('active')){
			$(this).removeClass('active');
			$(this).find('span').first().show();
			$(this).find('.inline-form').hide();
		} else {
			$(this).addClass('active');
			$(this).find('span').first().hide();
			$(this).find('.inline-form').show();
			$(this).find('.inline-form:not(.tree-select) input').focus();
		}
	});
	
	$(".all_quick").click(function(event){
		event.preventDefault();
		if ($(this).hasClass('active')){
			$(this).removeClass('active');
			$('.quick').removeClass('active');
			$('.quick > span').show();
			$('.quick .inline-form').hide();
		} else {
			$(this).addClass('active');
			$('.quick').addClass('active');
			$('.quick > span').hide();
			$('.quick .inline-form').show();
		}
	});
	
	
	$('.quick .inline-form:not(.tree-select) input').focus(function(){
	  var that = this;
	  setTimeout(function(){ that.selectionStart = that.selectionEnd = that.value.length; }, 0);
	});
	
	if ($('body .quick').length){
		$(document).keyup(function(event) {
			if (event.key === "Escape"){
				$('.all_quick').removeClass('active');
				$('.quick').removeClass('active');
				$('.quick span').show();
				$('.quick .inline-form').hide();
			}
		});
	}
	
	$('body').on('keypress', '.inline-form .textarea', function (event){
		if (event.which === 13 && event.ctrlKey){
			event.preventDefault();
			var $this = $(this);
			var $module = $(this).parents('.table-row').attr('data-module');
	    var $backend_module = $(this).parents('.table-row').attr('data-backend-module');
	    var $id = $(this).parents('.table-row').attr('data-id');
	    var $before = '';
	    var $after = '';
	    if ($this.attr('data-before')) $before = $this.attr('data-before');
	    if ($this.attr('data-after')) $after = $this.attr('data-after');
	    
			var $data = $(this).serializeArray();
			var $key = $(this).attr('name');
			$data.push({name: 'csrf_token', value: document.querySelector('[data-csrf]')?.dataset.csrf });
			$data.push({name: 'key', value: $key });
			$data.push({name: 'update', value: 1 });
	    
			$.post("ajax_form.php?module="+$module+"&backend_module="+$backend_module+"&id="+$id+"&action=quick", $data, function(data){
				$this.parents('.table-cell').find('span').html($before+data+$after).show();
				$this.parents('.inline-form').hide();
				$this.parents('.table-cell').removeClass('active');
				$this.parents('.table-row').nextAll().each(function(index) {
					if ($(this).children('.active').find('input[name="'+$key+'"]').length){
						$(this).children('.active').find('input[name="'+$key+'"]').focus();
						return false;
					}
				});
			});
		}
	});
	
	$('body').on('keypress', '.inline-form .field', function (event){
		if (event.which === 13){
			event.preventDefault();
			var $this = $(this);
			var $module = $(this).parents('.table-row').attr('data-module');
	    var $backend_module = $(this).parents('.table-row').attr('data-backend-module');
	    var $id = $(this).parents('.table-row').attr('data-id');
	    var $before = '';
	    var $after = '';
	    if ($this.attr('data-before')) $before = $this.attr('data-before');
	    if ($this.attr('data-after')) $after = $this.attr('data-after');
	    
			var $data = $(this).serializeArray();
			var $key = $(this).attr('name');
			$data.push({name: 'csrf_token', value: document.querySelector('[data-csrf]')?.dataset.csrf });
			$data.push({name: 'key', value: $key });
			$data.push({name: 'update', value: 1 });
	    
			$.post("ajax_form.php?module="+$module+"&backend_module="+$backend_module+"&id="+$id+"&action=quick", $data, function(data){
				$this.parents('.table-cell').find('span').html($before+data+$after).show();
				$this.parents('.inline-form').hide();
				$this.parents('.table-cell').removeClass('active');
				$this.parents('.table-row').nextAll().each(function(index) {
					if ($(this).children('.active').find('input[name="'+$key+'"]').length){
						$(this).children('.active').find('input[name="'+$key+'"]').focus();
						return false;
					}
				});
			});
		}
	});
	
	$('body').on('change', '.inline-form .select', function (event){
		event.preventDefault();
		var $this = $(this);
		var $module = $(this).parents('.table-row').attr('data-module');
	  var $backend_module = $(this).parents('.table-row').attr('data-backend-module');
    var $id = $(this).parents('.table-row').attr('data-id');
  
		var $data = $(this).serializeArray();
		var $key = $(this).attr('name');
		$data.push({name: 'csrf_token', value: document.querySelector('[data-csrf]')?.dataset.csrf });
		$data.push({name: 'key', value: $key });
		$data.push({name: 'update', value: 1 });
    
		$.post("ajax_form.php?module="+$module+"&backend_module="+$backend_module+"&id="+$id+"&action=quick", $data, function(data){
			$this.parents('.table-cell').find('span').html($this.find("option:selected").text()).show();
			$this.parents('.inline-form').hide();
			$this.parents('.table-cell').removeClass('active');
			$this.parents('.table-row').nextAll().each(function(index) {
				if ($(this).children('.active').find('input[name="'+$key+'"]').length){
					$(this).children('.active').find('input[name="'+$key+'"]').focus();
					return false;
				}
			});
		});
	});
	
}
