tinymce.PluginManager.add('files', function (editor, url) {
	
	function createList(){
  	var dataList = [];
		if ($('.files-data').length){
  		$('.files-data').each(function(){
  			var $filename = $('input[name="files_editor['+$(this).val()+']"]').val();
  			var $category = $('input[name="files_editor['+$(this).val()+']"]').attr('data-category');
  			var $language = $('input[name="files_editor['+$(this).val()+']"]').attr('data-language');
  			var $id = $(this).val();
  			dataList.push({ text: $filename, value: $filename, id: $id, category: $category, language: $language });
  		})
  	}
  	return dataList;
	}
	
	function createHTML(dataList){
  	var $table = $("<div>").addClass('table');
  	var $container = $("<div>").addClass('table-body').addClass('mce');
  	var $head = $('.table.files .table-head').clone();
    var $template = $('#skeleton-box.files').contents();
	  $head.find('.toolbar').remove();
    $table.append($head);
    for (var dataIndex = 0; dataIndex < dataList.length; dataIndex++) {
    	if (dataList[dataIndex] && dataList[dataIndex].value){
	    	var $templateClone = $template.clone();
	    	$templateClone.attr('data-filename', dataList[dataIndex].value.replace(/[^0-9a-zA-Z]/g, ""));
	    	$templateClone.find('.toolbar').remove();
	      $templateClone.removeAttr('data-file');
	      $templateClone.removeAttr('data-filename');
    		$templateClone.removeAttr('data-module');
	      $templateClone.removeAttr('data-backend-module');    		
	    	$templateClone.find('.sortorder').html('#'+dataList[dataIndex].id);
	    	$templateClone.find('.table-cell.icon .skeleton').replaceWith(dataList[dataIndex].value);
				$templateClone.find('.table-cell.category').html(dataList[dataIndex].category);
	      $templateClone.attr('data-id', dataList[dataIndex].id);
    		$templateClone.attr('id', dataList[dataIndex].id);
	  		$container.append($templateClone);
	  	}
    }
    $table.append($container);
    return $table.prop('outerHTML');
	}
  	
	editor.ui.registry.addButton('files', {
		icon: 'duplicate',
    onAction: () => {
    	openDialog(createList());
			$('.table-body.mce .table-row').click(function(){
				editor.insertContent('[FILE='+$(this).attr('data-id')+']');
        editor.windowManager.close();
			});
    }
  });
  
	editor.ui.registry.addMenuItem('files', {
		text: 'Files',
		context: 'insert',
    onAction: () => {
    	openDialog(createList());
			$('.table-body.mce .table-row').click(function(){
				editor.insertContent('[FILE='+$(this).attr('data-id')+']');
        editor.windowManager.close();
			});
    }
  });
  
  const openDialog = (dataList) => editor.windowManager.open({
  	title: 'Files',
    size: 'medium',
		body: {
			type: 'panel',
			items: [{
				type: 'htmlpanel',
				html: createHTML(dataList)
			}]
		},
		buttons: [{ type: 'cancel', text: 'Close' }] 
	});

  return {
    getMetadata: function () {
      return {
        title: "Files",
        url: "https://www.entire-media.de"
      };
    }
  };
});