tinymce.PluginManager.add('gallery', function (editor, url) {
	
	function createList(){
  	var dataList = [];
		if ($('.images-data').length){
  		$('.images-data').each(function(){
  			var $filename = $('input[name="images_editor['+$(this).val()+']"]').val();
  			var $path = $('input[name="images_editor['+$(this).val()+']"]').attr('data-path');
  			var $id = $(this).val();
  			dataList.push({ text: $filename, value: $filename, path: $path, id: $id });
  		})
  	}
  	return dataList;
	}
	
	function createHTML(dataList){
  	var $container = $("<div>").addClass('table-grid').addClass('mce');
    var $template = $('#skeleton-box.images').contents();
    for (var dataIndex = 0; dataIndex < dataList.length; dataIndex++) {
    	if (dataList[dataIndex] && dataList[dataIndex].value){
	    	var $templateClone = $template.clone();
	    	$templateClone.attr('data-filename', dataList[dataIndex].value.replace(/[^0-9a-zA-Z]/g, ""));
	    	$templateClone.find('.grid-action').remove();
	      $templateClone.removeAttr('data-file');
	      $templateClone.removeAttr('data-filename');
    		$templateClone.removeAttr('data-module');
	      $templateClone.removeAttr('data-backend-module');
	    	$templateClone.find('.grid-title').html('#'+dataList[dataIndex].id);
	    	$templateClone.find('.grid-content img').attr('src', dataList[dataIndex].path+dataList[dataIndex].value);
	    	$templateClone.find('.grid-content .skeleton').replaceWith($templateClone.find('.grid-content img'));
	      $templateClone.attr('data-id', dataList[dataIndex].id);
    		$templateClone.attr('id', dataList[dataIndex].id);
    		$templateClone.find('.caption').html(dataList[dataIndex].value);
	  		$container.append($templateClone);
	  	}
    }
    return $container.prop('outerHTML');
	}
  	
	editor.ui.registry.addButton('gallery', {
		icon: 'gallery',
    onAction: () => {
    	openDialog(createList());
			$('.table-grid.mce .table-cell').click(function(){
				editor.insertContent('[IMAGE='+$(this).attr('data-id')+']');
        editor.windowManager.close();
			});
    }
  });
  
	editor.ui.registry.addMenuItem('gallery', {
		text: 'Gallery',
		context: 'insert',
    onAction: () => {
    	openDialog(createList());
			$('.table-grid.mce .table-cell').click(function(){
				editor.insertContent('[IMAGE='+$(this).attr('data-id')+']');
        editor.windowManager.close();
			});
    }
  });
  
  const openDialog = (dataList) => editor.windowManager.open({
  	title: 'Gallery',
    size: 'medium',
		body: {
			type: 'panel',
			items: [{
				type: 'htmlpanel',
				html: createHTML(dataList)
			}]
		},
		buttons: [{ type: 'cancel', text: 'Close' }] 
	});

  return {
    getMetadata: function () {
      return {
        title: "Gallery",
        url: "https://www.entire-media.de"
      };
    }
  };
});