<?php
$user_id = $_SESSION['backend']['id_session'];

$update = false;
$response = remote_call('https://update.comator.org/update.php?domain='.$_SERVER['SERVER_NAME']);
foreach ($response->module AS $key => $value){
	if ($key != 'setup'){
		if ($key == 'core' && is_file('version.txt')){
			$fh = fopen('version.txt', 'r');
			while ($line = fgets($fh)) {
				if (version_compare($value->version, convertToVersionLogout($line), '>')) $update = true;
			}
			fclose($fh);
		} else if (is_file('modules/'.$key.'/version.txt')) {
			$fh = fopen('modules/'.$key.'/version.txt', 'r');
			while ($line = fgets($fh)) {
				if (version_compare($value->version, convertToVersionLogout($line), '>')) $update = true;
			}
			fclose($fh);				
		}
	}
}

$sql = "SELECT * FROM settings_users WHERE id = :id LIMIT 1";
$result = $conn->prepare($sql);
$result->bindValue(':id', $user_id, PDO::PARAM_INT);
$result->execute();
while ($arr = $result->fetch()){
	$module_ini = get_encryption_ini($backend_module);
	$encryption_key = $module_ini['encryption_key'] ?? null;
	$loginname_label = $arr['username'];
	if ($arr['firstname'] && $arr['lastname']) $loginname_label = decrypt_field($arr, 'firstname', $encryption_key)." ".decrypt_field($arr, 'lastname', $encryption_key);
	
	print "
<div class='logout'>";
if ($_SESSION['backend']['permissions']['admin']) {
	if ($update === true) {
		print "<a href='index.php?module=modules_manager&backend_module=backend_modules'><i class='material-icons pulse md-24'>update</i></a>";
	} else {
		print "<a href='index.php?module=backend_modules&backend_module=backend_modules'><i class='material-icons md-24'>settings</i></a>";
	}
}
	print "
	<span>".LABEL_LOGGED_IN."</span>
	<strong>
		<a href='#' class='edit' data-id='".$arr['id']."' data-module='settings_users' data-backend-module='settings' title='".LABEL_EDIT."'>".$loginname_label."</a>
	</strong>
	<a href='?logout' title=".LABEL_LOGOUT.">
		<i class='material-icons md-24'>logout</i>
	</a>
</div><!-- /.logout -->";
}


function convertToVersionLogout($version) {
	if (is_numeric($version)) {
		return "0.0." . $version;
   }
   return $version;
}