<?php
$module_ini = get_encryption_ini($backend_module);
$encryption_key = $module_ini['encryption_key'] ?? null;
$pepper = $module_ini['pepper'] ?? null;
$enc = $module_ini['version'] ?? 'plain';

if (isset($_GET['action'])) $action = addslashes(trim(strip_tags(stripslashes(rawurldecode($_GET['action'])))));
else $action = false;

if (isset($_POST['submit'])) {
	if ($_POST['submit'] == 'reload') $update = 0;
}

if ($update) {
	
	if(!$lastname OR !$firstname OR !$email OR !$username OR !$password){
		$error = LABEL_ERROR_MANDATORY;
	}

	if (isset($_POST['date'])) {
		$datetime = DateTime::createFromFormat('Y-m-d\TH:i', $_POST['date']);
		$datetime = $datetime->getTimestamp();
	}
	
	for($i = 1; $i <= $count_fields; $i++) {
	
		if ($field[$i] == 'password' || !isset($field[$i])) continue;
	
		if ($encryption_key && check_column($module, $field[$i].'_hash')) {
			$original_value = ${$field[$i]};
	
			${$field[$i]} = encrypt_value($original_value, $encryption_key);
			${$field[$i].'_hash'} = hash_value($original_value, $pepper);
	
			if (check_column($module, $field[$i].'_plain')) {
				${$field[$i].'_plain'} = $original_value;
			}
		}
	}
	
	if (!isset($error) && $update == 1){
		if ($action == 'edit'){
			$sql = "UPDATE ".$module." SET ";
		} else {
			$sql = "INSERT INTO ".$module." SET ";
			if (check_column($module, 'enc') && !in_array('enc', $field)) {
				$sql .= "enc = :enc, ";
			}
		}
    for($i = 1; $i <= $count_fields; $i++){
    	if ($field[$i] != 'password'){
	    	if (isset(${$field[$i]})){
		    	if ($i == 1) $sql.= " ".$field[$i]." = :".$field[$i]." ";
		    	else $sql.= ", ".$field[$i]." = :".$field[$i]." ";
		    }
		  }
    }
    if ($password != 'unchanged') {
    	$password = password_hash($password, PASSWORD_DEFAULT);
    	$sql.= ", password = :password";
    }
		if ($action == 'edit') $sql.= " WHERE id = :id";
		
		$result = $conn->prepare($sql);
    for($i = 1; $i <= $count_fields; $i++){
    	if ($field[$i] != 'password'){
	  		if (isset(${$field[$i]})){
					$result->bindValue(':'.$field[$i], ${$field[$i]});
				}
	  		if (isset(${$field[$i].'_hash'})){
					$result->bindValue(':'.$field[$i].'_hash', ${$field[$i].'_hash'});
				}
	  		if (isset(${$field[$i].'_plain'})){
					$result->bindValue(':'.$field[$i].'_plain', ${$field[$i].'_plain'});
				}
			}
		}
    if ($password != 'unchanged') {
			$result->bindValue(':password', $password);
    }
		if ($action == 'edit') $result->bindValue(':id', $id);
		else {
			if (check_column($module, 'enc')) $result->bindValue(':enc', $enc);
		}
		
		if ($result->execute()){
			if ($action != 'edit') $id = $conn->lastInsertId();
			
			if ($action == 'add'){
		    for($i = 1; $i <= $count_fields; $i++){
		    	unset(${$field[$i]});
		    }
		    unset($update);
		    $url_form = "popup_form.php?module=".$module."&backend_module=".$backend_module."&id=".$id."&action=edit&success";
		  } elseif ($action == 'copy'){
		    $url_form = "popup_form.php?module=".$module."&backend_module=".$backend_module."&id=".$id."&action=edit&success";
			} else $update_parent = true;
			
			if (isset($url_form)){
		    print "
				<script type='text/javascript'>
				opener.document.forms[0].submit();
				window.open('".$url_form."', '_self');
				</script>";
			}
		}
	}
}

include('includes/function/load.php');

if ($module_ini && $encryption_key && isset($arr)) {
	if (file_exists('modules/'.$backend_module.'/encrypt_config.php')){
		$encrypt_config = include 'encrypt_config.php';
		$table_config = $encrypt_config[$module] ?? [];
		
		foreach ($table_config as $key => $config) {
			if (isset($arr[$key])) {
				${$key} = decrypt_field($arr, $key, $encryption_key);
			}
		}
	}
}

if (isset($datetime) && $datetime) $datetime = date('Y-m-d\TH:i', $datetime);
else $datetime = date('Y-m-d\TH:i');
$password = 'unchanged';