<?php
ini_set('display_errors','1');
error_reporting (E_ALL);
session_start();
setlocale (LC_ALL, 'de_DE');
header('Content-Type: text/html; charset=utf-8');
include('backend.php');

?>
<!DOCTYPE html>
<html lang='de'>	
	<head>
		<meta charset='utf-8' />
		<title><?php print $title_page; ?></title>
		
		<link rel="apple-touch-icon" sizes="180x180" href="images/favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="images/favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="images/favicon/favicon-16x16.png">
		<link rel="manifest" href="images/favicon/site.webmanifest">
		<link rel="mask-icon" href="images/favicon/safari-pinned-tab.svg" color="#5bbad5">
		<link rel="shortcut icon" href="images/favicon/favicon.ico">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="msapplication-config" content="images/favicon/browserconfig.xml">
		<meta name="theme-color" content="#ffffff">
		
		<!-- Vendor Styles -->
	
		<!-- App Styles -->
		<link rel='stylesheet' href='css/treeselect.css' />
		<link rel='stylesheet' href='css/fancybox.min.css' />
		<link rel='stylesheet' href='css/jquery-ui-1.13.2.min.css' />
		<link rel='stylesheet' href='css/fonts.css' />
		<link rel='stylesheet' href='css/style.css' />
		<link rel='stylesheet' href='css/custom.css' />
	
		<!-- Vendor JS -->
		<script type="text/javascript" src="js/jquery-3.7.1.min.js"></script>
		<script type="text/javascript" src="js/jquery-ui-1.13.2.min.js"></script>
		<script type="text/javascript" src="js/treeselect.min.js"></script>
		<script type="text/javascript" src="js/fancybox.min.js"></script>
		<script type="text/javascript" src="js/uploader/jquery.ui.widget.js"></script>
	  <script type="text/javascript" src="js/ace/ace.js" charset="utf-8"></script>
	  <script type="text/javascript" src="js/ace/ext-language_tools.js" charset="utf-8"></script>
	  <script type="text/javascript" src="js/tinymce/tinymce.min.js"></script>
		<script type="text/javascript" src="js/uploader/jquery.iframe-transport.js"></script>
		<script type="text/javascript" src="js/uploader/jquery.fileupload.js"></script>
		<script type="text/javascript" src="js/uploader/jquery.fileupload-process.js"></script>
	
		<!-- App JS -->
		<script type="text/javascript" src="js/defaults.js"></script>
		<script type="text/javascript" src="js/toggle.js"></script>
		<script type="text/javascript" src="js/upload.js"></script>
		<script type="text/javascript" src="js/editor.js"></script>
		<script type="text/javascript" src="js/functions.js"></script>
		<script type="text/javascript" src="js/shop.js"></script>
		<script type="text/javascript" src="js/custom.js"></script>
		<?php
		if (isset($backend_module) && is_file('modules/'.$backend_module.'/js/functions.js')) {
			print "<script type='text/javascript' src='modules/".$backend_module."/js/functions.js'></script>";
		}
		?>
	</head>
	<body>
		<div class='wrapper' data-csrf='<?=csrf_token();?>'>
			<?php
			if (isset($_SESSION['backend'][$session_name]) && $_SESSION['backend'][$session_name]){
				preg_match("/(.*)_modules/i", $module, $modules_key);
				preg_match("/(.*)_options/i", $module, $options_key);
				preg_match("/(.*)_levels/i", $module, $level_module_key);
				preg_match("/id_(.*)/i", $module, $id_module_key);
				
				if (isset($modules_key[1])) {
					include('modules_filter.php');
				} else if (isset($options_key[1])) {
					include('options.php');
				} else if (isset($backend_module) && isset($level_module_key[1]) && is_file('modules/'.$backend_module.'/'.$level_module_key[1].'_levels_filter.php')) {
					include('modules/'.$backend_module.'/'.$level_module_key[1].'_levels_filter.php');
				} else if (isset($level_module_key[1]) && is_file('levels_filter.php')) {
					include('levels_filter.php');
				} else if (isset($backend_module) && isset($id_module_key[1]) && is_file('modules/'.$backend_module.'/id_'.$id_module_key[1].'_filter.php')) {
					include('modules/'.$backend_module.'/id_'.$id_module_key[1].'_filter.php');
				} else if (isset($backend_module) && isset($id_module_key[1]) && is_file('modules/'.$backend_module.'/id_filter.php')) {
					include('modules/'.$backend_module.'/id_filter.php');
				} else if (isset($id_module_key[1])){
					include('id_filter.php');
				} else if (isset($backend_module) && is_file('modules/'.$backend_module.'/'.$module.'_filter.php')) {
					include('modules/'.$backend_module.'/'.$module.'_filter.php');
				}
			} else {
				include('login.php');
			}
			?>
		</div><!-- /.wrapper -->
	</body>
</html>