<?php
define('IN_COMATOR', true);

include('comator/includes/function/database.php');
include('comator/includes/function/helper.php');
include('includes/function/helper.php');
include('includes/function/assets.php');
include('includes/function/navigation.php');


include_once('comator/includes/function/secure.php');
csrf_check();

if (!is_file('comator/dbopen.php')){
	if (is_file('comator/setup.php')) header('Location: /comator/setup.php');
}

include('comator/dbopen.php');
$conn = database_connect($db);
if ($conn == NULL) {
	print "Datenbank verbindung nicht m&ouml;glich!!!";
	die();
}

$c_languages = false;
$sql = "SELECT id FROM languages ";
$result = $conn->prepare($sql);
$result->execute();
$count_languages = $result->rowCount();
if ($count_languages > 1) $c_languages = true;

$sql = "SELECT title, value FROM settings_options";
$result = $conn->prepare($sql);
$result->execute();
while ($arr = $result->fetch()){
	$title_settings = $arr['title'];
	$admin_settings['module'][$title_settings] = $arr['value'];
	if ($arr['value']) $$title_settings = str_replace('[DOMAIN]', str_replace('www.', '', $_SERVER['SERVER_NAME']), $arr['value']);
	else $$title_settings = $arr['value'];
}

include('url_parse.php');
include('predo.php');


if ($c_languages) $sql = "SELECT label, text FROM frontend_labels WHERE c_active = '1' AND language = :language ";
else $sql = "SELECT label, text FROM frontend_labels WHERE c_active = '1' ";
$result = $conn->prepare($sql);
if ($c_languages) $result->bindValue(':language', $language, PDO::PARAM_STR);
$result->execute();
while($arr = $result->fetch()){
	$arr['text'] = str_replace('[YEAR]', date('Y'), $arr['text']);
  if (!defined($arr['label'])) define($arr['label'], $arr['text']);
}

$level_class = NULL;
if (isset($content_guidv4) && $content_guidv4){
	if ($c_languages) $sql = "SELECT class FROM content_levels WHERE guidv4 = :guidv4 AND language = :language LIMIT 1";
	else $sql = "SELECT class FROM content_levels WHERE guidv4 = :guidv4 LIMIT 1";
	$result = $conn->prepare($sql);
	$result->bindValue(':guidv4', $content_guidv4, PDO::PARAM_STR);
	if ($c_languages) $result->bindValue(':language', $language, PDO::PARAM_STR);
	$result->execute();
	if ($result->rowCount()){
		$arr = $result->fetch();
		$level_class = $arr['class'];
	}
}

$old_content = NULL;

if (isset($old_content) && $old_content) $content = $old_content;


if (isset($_GET['note'])) {
	$note = input_in($_GET['note'], 'string');
	if (defined($note)) $note = constant($note);
}