<?php
function renderNavigation(string $position = 'main', string $class = '', ?string $parent_guidv4 = null, array $options = []): void {
	global $conn, $language, $content, $content_data;
	
	$options = array_merge([
		'wrap' => true,
		'icon' => false,
		'before_html' => NULL,
		'after_html' => NUll
	], $options);

	$sql = "SELECT * FROM content_levels WHERE position LIKE :position AND c_active = '1' AND language = :language ";
	if ($parent_guidv4) $sql.= "AND parent_guidv4 = :parent_guidv4 ";
	else $sql.= "AND parent_guidv4 IS NULL ";
	$sql.= "ORDER BY sortorder";
	$result = $conn->prepare($sql);
	$result->bindValue(':position', "%{$position}%", PDO::PARAM_STR);
	$result->bindValue(':language', $language, PDO::PARAM_STR);
	if ($parent_guidv4) $result->bindValue(':parent_guidv4', $parent_guidv4, PDO::PARAM_STR);
	$result->execute();

	if ($result->rowCount()) {
		if ($options['wrap']) print "<nav class='".$class."'><ul>";
		while ($arr = $result->fetch()) {
			renderNavItem($arr, $position, $options);
		}
		if ($options['wrap']) print "</ul></nav>";
	}
}

function renderNavItem(array $item, string $position, array $options = []): void {
	global $conn, $c_languages, $language, $content, $content_data, $default_guidv4;
	
	$options = array_merge([
		'wrap' => true,
		'icon' => false,
		'before_html' => NULL,
		'after_html' => NUll
	], $options);
	
	$hasChildren = hasSubMenu($item['guidv4'], $position);
  $isCurrent = $item['url'] === $content || ($content_data[0] ?? null) === $item['guidv4'];
    
  if ($item['link']) {
    $url = $item['link'];
    $linkstart = substr($url, 0, 7);
    $target = '_self';
    if ($linkstart == "http://" OR $linkstart == "https:/") $target = '_blank';
    $aria_label = strip_tags($item['linktext'] ?: $item['title']);
  } else {
    $urlSlug = url_slug($item['url']);
    if ($c_languages) $url = $hasChildren ? '#' : "/".$language."/".$urlSlug."/";
    else $url = $hasChildren ? '#' : "/".$urlSlug."/";
		if (isset($default_guidv4) && $default_guidv4 && $default_guidv4 == $item['guidv4']) {
			if ($c_languages) $url = $hasChildren ? '#' : "/".$language."/";
			else $url = $hasChildren ? '#' : "/";
		}
    $target = '_self';
    $aria_label = strip_tags($item['title']);
  }
	
	if (!empty($item['class'])) {
		if (!empty($options['icon'])) {
			if ($options['icon'] === true) $linktext = "<i class='material-symbols md-24'>".$item['class']."</i>";
			else $linktext = "<i class='".$options['icon']."-".$item['class']."'></i>";
		} else {
			$linktext = "<span class='".$item['class']."'>".$options['before_html'].$item['title'].$options['after_html']."</span>";
		}
	} else {
		$linktext = $options['before_html'].$item['title'].$options['after_html'];
	}
		
		
	if ($isCurrent) print "<li class='current'>";
	else print "<li>";
	if (isset($aria_label) && !empty($options['icon'])) print "<a href='".$url."' aria-label='".$aria_label."' target='".$target."'>".$linktext."</a>";
	else print "<a href='".$url."' target='".$target."'>".$linktext."</a>";
		
  if ($hasChildren) {
  	$children = getSubMenuItems($item['guidv4'], $position);
		if (!empty($children)) {
			print "<div class='sub-nav-container'><ul class='sub-nav'>";
  		foreach ($children AS $child) {
				renderNavItem($child, $position, $options);
			}
			print "</ul></div><!-- /.sub-nav-container -->";
		}
  }
	print "</li>";
    
}

function hasSubMenu(string $parent_guidv4, string $position): bool {
	global $conn, $language;
  $sql = "SELECT 1 FROM content_levels WHERE position LIKE :position AND c_active = '1' AND language = :language AND parent_guidv4 = :parent_guidv4 LIMIT 1";
  $result = $conn->prepare($sql);
  $result->bindValue(':position', "%{$position}%", PDO::PARAM_STR);
  $result->bindValue(':language', $language, PDO::PARAM_STR);
  $result->bindValue(':parent_guidv4', $parent_guidv4, PDO::PARAM_STR);
  $result->execute();
  return $result->rowCount() > 0;
}

function getSubMenuItems(string $parent_guidv4, string $position): array {
	global $conn, $language;
	$sql = "SELECT * FROM content_levels WHERE position LIKE :position AND c_active = '1' AND language = :language AND parent_guidv4 = :parent_guidv4 ORDER BY sortorder";
	$result = $conn->prepare($sql);
	$result->bindValue(':position', "%{$position}%", PDO::PARAM_STR);
	$result->bindValue(':language', $language, PDO::PARAM_STR);
	$result->bindValue(':parent_guidv4', $parent_guidv4, PDO::PARAM_STR);
	$result->execute();
	return $result->fetchAll(PDO::FETCH_ASSOC);
}