<?php
$canonical_host = "https://".$_SERVER['SERVER_NAME'];


if (!isset($meta_title) OR !$meta_title) $meta_title = NULL;
if (!isset($meta_description) OR !$meta_description) $meta_description = NULL;
$canonical_link = NULL;
$canonical_prev = NULL;
$canonical_next = NULL;
$seo_image = NULL;
$canonical_lang = array();
$meta_robots = 'index, follow';

$sql_lang = "SELECT iso FROM languages WHERE c_active = '1' ";
$result_lang = $conn->prepare($sql_lang);
$result_lang->execute();
if ($result_lang->rowCount()){
	while ($arr_lang = $result_lang->fetch()){
		$canonical_lang[$arr_lang['iso']] = NULL;
	}
}

if ((isset($id) && $id) && (isset($content) && $content)){
	if ($content === 'products') {
    $sql_seo = "SELECT url, title, meta_title, meta_description FROM products_content WHERE id_module = :id_module AND language = :language LIMIT 1";
    $result_seo = $conn->prepare($sql_seo);
		$result_seo->bindValue(':id_module', $id, PDO::PARAM_INT);
		$result_seo->bindValue(':language', $language, PDO::PARAM_STR);
		$result_seo->execute();
		if ($result_seo->rowCount()){
			$arr_seo = $result_seo->fetch();
			if ($arr_seo['meta_title']) $meta_title = $arr_seo['meta_title'];
			else if ($arr_seo['title']) $meta_title = $arr_seo['title'];
			if ($arr_seo['meta_description']) $meta_description = $arr_seo['meta_description'];
			
			$canonical_link = $canonical_host."/".$content."/".url_slug($arr_seo['url']).".html";
			if ($c_languages) $canonical_link = $canonical_host."/".$language."/".$content."/".url_slug($arr_seo['url']).".html";
			
			foreach ($canonical_lang AS $lang_iso => &$url) {
				if ($lang_iso == $language){
					$url = $canonical_link;
				} else {
					$sql_seo = "SELECT url FROM products_content WHERE id_module = :id_module AND language = :language LIMIT 1";
			    $result_seo = $conn->prepare($sql_seo);
					$result_seo->bindValue(':id_module', $id, PDO::PARAM_INT);
					$result_seo->bindValue(':language', $lang_iso, PDO::PARAM_STR);
					$result_seo->execute();
					if ($result_seo->rowCount()){
						$arr_seo = $result_seo->fetch();
						$url = $canonical_host."/".$content."/".url_slug($arr_seo['url']).".html";
						if ($c_languages) $url = $canonical_host."/".$lang_iso."/".$content."/".url_slug($arr_seo['url']).".html";
					}
				}
			}
				
		}
  } else if (check_table($content)){
		$sql_seo = "SELECT url, title, meta_title, meta_description FROM ".$content." WHERE id = :id LIMIT 1";
		$result_seo = $conn->prepare($sql_seo);
		$result_seo->bindValue(':id', $id, PDO::PARAM_INT);
		$result_seo->execute();
		if ($result_seo->rowCount()){
			$arr_seo = $result_seo->fetch();
			if ($arr_seo['meta_title']) $meta_title = $arr_seo['meta_title'];
			else if ($arr_seo['title']) $meta_title = $arr_seo['title'];
			if ($arr_seo['meta_description']) $meta_description = $arr_seo['meta_description'];
			
			$canonical_link = $canonical_host."/".$content."/".url_slug($arr_seo['url']).".html";
			if ($c_languages) $canonical_link = $canonical_host."/".$language."/".$content."/".url_slug($arr_seo['url']).".html";
			
			if ($content == 'news' OR $content == 'events'){
				if (check_table('images')){
					$sql_seo_image = "SELECT images.file, 
													module_images.c_enlarge, 
													IF(module_images.title != '', module_images.title, images.title) AS title  
													FROM images AS images 
													LEFT JOIN ".$content."_images AS module_images ON module_images.id_media = images.id 
													WHERE module_images.id_module = :id_module 
													GROUP BY module_images.id_media ORDER BY module_images.sortorder ASC LIMIT 1";
					$result_seo_image = $conn->prepare($sql_seo_image);
					$result_seo_image->bindValue(':id_module', $id, PDO::PARAM_INT);
					$result_seo_image->execute();
					if ($result_seo_image->rowCount()){
						$arr_seo_image = $result_seo_image->fetch();
						
						$img_url = "images/".$content."/";
						if ($arr_seo_image['c_enlarge'] && is_file($img_url."lightbox/".$arr_seo_image['file'])) $img_url .= "lightbox/".$arr_seo_image['file'];
						else $img_url .= "thumb1/".$arr_seo_image['file'];
						
						if (is_file($img_url)){
							$seo_image = $canonical_host."/".$img_url;
						}
					}
				}
			}
			
		}
	}
} else if (isset($content_guidv4) && $content_guidv4){
	$sql_seo = "SELECT url, title, meta_title, meta_description FROM content_levels WHERE guidv4 = :guidv4 AND language = :language AND c_active = '1' LIMIT 1";
	$result_seo = $conn->prepare($sql_seo);
	$result_seo->bindValue(':guidv4', $content_guidv4, PDO::PARAM_STR);
	$result_seo->bindValue(':language', $language, PDO::PARAM_STR);
	$result_seo->execute();
	if ($result_seo->rowCount()){
		$arr_seo = $result_seo->fetch();
		if ($arr_seo['meta_title']) $meta_title = $arr_seo['meta_title'];
		else if ($arr_seo['title'] && $meta_title) $meta_title = $arr_seo['title']." | ".$meta_title;
		if ($arr_seo['meta_description']) $meta_description = $arr_seo['meta_description'];
		
		$canonical_link = $canonical_host."/".url_slug($arr_seo['url'])."/";
		if ($c_languages) $canonical_link = $canonical_host."/".$language."/".url_slug($arr_seo['url'])."/";
		if (isset($default_guidv4) && $default_guidv4 && $default_guidv4 == $content_guidv4) {
			$canonical_link = $canonical_host."/";
			if ($c_languages) $canonical_link = $canonical_host."/".$language."/";
		}
		
		if (check_table('teaser')){
			$sql_seo_teaser = "SELECT teaser.* FROM teaser AS teaser 
										LEFT JOIN teaser_levels_links AS levels_links ON levels_links.id_module = teaser.id 
										WHERE levels_links.guidv4 = :guidv4 AND teaser.language = :language AND teaser.c_active = '1' 
										GROUP BY teaser.id ORDER BY teaser.sortorder ASC LIMIT 1";
			
			$result_seo_teaser = $conn->prepare($sql_seo_teaser);
			$result_seo_teaser->bindValue(':guidv4', $content_guidv4, PDO::PARAM_STR);
			$result_seo_teaser->bindValue(':language', $language, PDO::PARAM_STR);
			$result_seo_teaser->execute();
			if ($result_seo_teaser->rowCount()){
				$arr_seo_teaser = $result_seo_teaser->fetch();
				
				
				if (check_table('images')){
					$sql_seo_image = "SELECT images.file, 
												module_images.c_enlarge, 
												IF(module_images.title != '', module_images.title, images.title) AS title  
												FROM images AS images 
												LEFT JOIN teaser_images AS module_images ON module_images.id_media = images.id 
												WHERE module_images.id_module = :id_module 
												GROUP BY module_images.id_media ORDER BY module_images.sortorder ASC LIMIT 1";
					$result_seo_image = $conn->prepare($sql_seo_image);
					$result_seo_image->bindValue(':id_module', $arr_seo_teaser['id'], PDO::PARAM_INT);
					$result_seo_image->execute();
					if ($result_seo_image->rowCount()){
						$arr_seo_image = $result_seo_image->fetch();
						
						
						$img_url = "images/teaser/";
						if ($arr_seo_image['c_enlarge'] && is_file($img_url."lightbox/".$arr_seo_image['file'])) $img_url .= "lightbox/".$arr_seo_image['file'];
						else $img_url .= "thumb1/".$arr_seo_image['file'];
						if (is_file($img_url)){
							$seo_image = $canonical_host."/".$img_url;
						}
					}
				}
			}
		}
		
		foreach ($canonical_lang AS $lang_iso => &$url) {
			if ($lang_iso == $language){
				$url = $canonical_link;
			} else {
				$sql_seo = "SELECT url FROM content_levels WHERE guidv4 = :guidv4 AND language = :language AND c_active = '1' LIMIT 1";
		    $result_seo = $conn->prepare($sql_seo);
				$result_seo->bindValue(':guidv4', $content_guidv4, PDO::PARAM_STR);
				$result_seo->bindValue(':language', $lang_iso, PDO::PARAM_STR);
				$result_seo->execute();
				if ($result_seo->rowCount()){
					$arr_seo = $result_seo->fetch();
					$url = $canonical_host."/".url_slug($arr_seo['url'])."/";
					if ($c_languages) $url = $canonical_host."/".$lang_iso."/".url_slug($arr_seo['url'])."/";
					if (isset($default_guidv4) && $default_guidv4 && $default_guidv4 == $content_guidv4) {
						$url = $canonical_host."/";
						if ($c_languages) $url = $canonical_host."/".$lang_iso."/";
					}
				}
			}
		}
	}
	
}


$seo_data = [
	'title' 			=> $meta_title,
	'description' => $meta_description,
	'robots' 			=> $meta_robots,
	'canonical' 	=> $canonical_link,
	'prev' 				=> $canonical_prev,
	'next' 				=> $canonical_next,
	'hreflang' 		=> $canonical_lang,
	'image'				=> $seo_image,
];